/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Tag;
import spectator-agent.spectator.atlas.ValidCharacters;

class TagsValuePair {
    private final Map<String, String> tags;
    private final double value;

    static TagsValuePair from(Measurement m) {
        return new TagsValuePair(TagsValuePair.convert(m.id()), m.value());
    }

    static TagsValuePair from(Map<String, String> commonTags, Measurement m) {
        Map<String, String> tags = TagsValuePair.convert(m.id());
        tags.putAll(commonTags);
        return new TagsValuePair(tags, m.value());
    }

    private static Map<String, String> convert(Id id) {
        HashMap<String, String> tags = new HashMap<String, String>();
        for (Tag t : id.tags()) {
            String k = ValidCharacters.toValidCharset(t.key());
            String v = ValidCharacters.toValidCharset(t.value());
            tags.put(k, v);
        }
        String name = ValidCharacters.toValidCharset(id.name());
        tags.put("name", name);
        return tags;
    }

    TagsValuePair(Map<String, String> tags, double value) {
        this.tags = Collections.unmodifiableMap(tags);
        this.value = value;
    }

    Map<String, String> tags() {
        return this.tags;
    }

    double value() {
        return this.value;
    }

    public String toString() {
        return "TagsValuePair(" + this.tags + "," + this.value + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof TagsValuePair)) {
            return false;
        }
        TagsValuePair other = (TagsValuePair)obj;
        return this.tags.equals(other.tags) && Double.compare(this.value, other.value) == 0;
    }

    public int hashCode() {
        int result = this.tags.hashCode();
        result = 31 * result + Double.hashCode(this.value);
        return result;
    }
}

