/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import java.util.Collections;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Gauge;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.atlas.DsType;
import spectator-agent.spectator.impl.AtomicDouble;

class AtlasGauge
implements Gauge {
    private final Id id;
    private final Clock clock;
    private final AtomicDouble value;
    private final Id stat;

    AtlasGauge(Id id, Clock clock) {
        this.id = id;
        this.clock = clock;
        this.value = new AtomicDouble(0.0);
        this.stat = id.withTag(DsType.gauge);
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public Iterable<Measurement> measure() {
        Measurement m = new Measurement(this.stat, this.clock.wallTime(), this.value());
        return Collections.singletonList(m);
    }

    @Override
    public void set(double v) {
        this.value.set(v);
    }

    @Override
    public double value() {
        return this.value.get();
    }
}

