/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.DistributionSummary;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Statistic;
import spectator-agent.spectator.atlas.DsType;
import spectator-agent.spectator.impl.StepDouble;
import spectator-agent.spectator.impl.StepLong;
import spectator-agent.spectator.impl.StepValue;

class AtlasDistributionSummary
implements DistributionSummary {
    private final Id id;
    private final StepLong count;
    private final StepLong total;
    private final StepDouble totalOfSquares;
    private final StepLong max;
    private final Id[] stats;

    AtlasDistributionSummary(Id id, Clock clock, long step) {
        this.id = id;
        this.count = new StepLong(0L, clock, step);
        this.total = new StepLong(0L, clock, step);
        this.totalOfSquares = new StepDouble(0.0, clock, step);
        this.max = new StepLong(0L, clock, step);
        this.stats = new Id[]{id.withTags(DsType.rate, Statistic.count), id.withTags(DsType.rate, Statistic.totalAmount), id.withTags(DsType.rate, Statistic.totalOfSquares), id.withTags(DsType.gauge, Statistic.max)};
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public Iterable<Measurement> measure() {
        ArrayList<Measurement> ms = new ArrayList<Measurement>(4);
        ms.add(this.newMeasurement(this.stats[0], this.count));
        ms.add(this.newMeasurement(this.stats[1], this.total));
        ms.add(this.newMeasurement(this.stats[2], this.totalOfSquares));
        ms.add(this.newMaxMeasurement(this.stats[3], this.max));
        return ms;
    }

    private Measurement newMeasurement(Id mid, StepValue v) {
        double rate = v.pollAsRate();
        long timestamp = v.timestamp();
        return new Measurement(mid, timestamp, rate);
    }

    private Measurement newMaxMeasurement(Id mid, StepLong v) {
        double maxValue = v.poll();
        long timestamp = v.timestamp();
        return new Measurement(mid, timestamp, maxValue);
    }

    @Override
    public void record(long amount) {
        if (amount > 0L) {
            this.count.getCurrent().incrementAndGet();
            this.total.getCurrent().addAndGet(amount);
            this.totalOfSquares.getCurrent().addAndGet((double)amount * (double)amount);
            this.updateMax(this.max.getCurrent(), amount);
        }
    }

    private void updateMax(AtomicLong maxValue, long v) {
        long p = maxValue.get();
        while (v > p && !maxValue.compareAndSet(p, v)) {
            p = maxValue.get();
        }
    }

    @Override
    public long count() {
        return this.count.poll();
    }

    @Override
    public long totalAmount() {
        return this.total.poll();
    }
}

