/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.util.Collections;
import java.util.function.ToDoubleFunction;
import spectator-agent.spectator.api.AbstractMeter;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Gauge;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;

class ObjectGauge<T>
extends AbstractMeter<T>
implements Gauge {
    private final ToDoubleFunction<T> f;

    ObjectGauge(Clock clock, Id id, T obj, ToDoubleFunction<T> f) {
        super(clock, id, obj);
        this.f = f;
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.singleton(new Measurement(this.id, this.clock.wallTime(), this.value()));
    }

    @Override
    public double value() {
        Object obj = this.ref.get();
        return obj == null ? Double.NaN : this.f.applyAsDouble(obj);
    }
}

