/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.lang.ref.WeakReference;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import spectator-agent.spectator.api.Registry;

final class GaugePoller {
    private static ThreadFactory factory = new ThreadFactory(){
        private final AtomicInteger next = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            String name = "spectator-gauge-polling-" + this.next.getAndIncrement();
            Thread t = new Thread(r, name);
            t.setDaemon(true);
            return t;
        }
    };
    private static ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(factory);

    static void schedule(WeakReference<Registry> ref, long delay, Consumer<Registry> poll) {
        AtomicReference futureRef = new AtomicReference();
        Runnable cancel = () -> {
            Future f = (Future)futureRef.get();
            if (f != null) {
                f.cancel(false);
            }
        };
        Runnable task = () -> {
            try {
                Registry r = (Registry)ref.get();
                if (r != null) {
                    long s = System.nanoTime();
                    poll.accept(r);
                    long l = System.nanoTime();
                } else {
                    cancel.run();
                }
            }
            catch (Throwable t) {
                cancel.run();
            }
        };
        futureRef.set(executor.scheduleWithFixedDelay(task, delay, delay, TimeUnit.MILLISECONDS));
    }

    private GaugePoller() {
    }
}

