/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Semaphore;
import spectator-agent.spectator.api.AggrMeter;
import spectator-agent.spectator.api.ArrayTagSet;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.CompositeCounter;
import spectator-agent.spectator.api.CompositeDistributionSummary;
import spectator-agent.spectator.api.CompositeGauge;
import spectator-agent.spectator.api.CompositeMeter;
import spectator-agent.spectator.api.CompositeTimer;
import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.DefaultId;
import spectator-agent.spectator.api.DistributionSummary;
import spectator-agent.spectator.api.Gauge;
import spectator-agent.spectator.api.GaugePoller;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Meter;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.api.Tag;
import spectator-agent.spectator.api.Timer;

public final class CompositeRegistry
implements Registry {
    private final Clock clock;
    private final CopyOnWriteArraySet<Registry> registries;
    private final ConcurrentHashMap<Id, AggrMeter> gauges;
    private final Semaphore pollSem = new Semaphore(1);

    CompositeRegistry(Clock clock) {
        this.clock = clock;
        this.registries = new CopyOnWriteArraySet();
        this.gauges = new ConcurrentHashMap();
        GaugePoller.schedule(new WeakReference<Registry>(this), 10000L, CompositeRegistry::pollGauges);
    }

    private static void pollGauges(Registry r) {
        ((CompositeRegistry)r).pollGauges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pollGauges() {
        if (this.pollSem.tryAcquire()) {
            try {
                for (Map.Entry<Id, AggrMeter> e : this.gauges.entrySet()) {
                    Id id = e.getKey();
                    Meter meter = e.getValue();
                    try {
                        if (meter.hasExpired()) continue;
                        for (Measurement m : meter.measure()) {
                            this.gauge(m.id()).set(m.value());
                        }
                    }
                    catch (StackOverflowError t) {
                        this.gauges.remove(id);
                    }
                    catch (ThreadDeath | VirtualMachineError t) {
                        throw t;
                    }
                    catch (Throwable t) {
                        this.gauges.remove(id);
                    }
                }
            }
            finally {
                this.pollSem.release();
            }
        }
    }

    private AggrMeter computeIfAbsent(Id id) {
        AggrMeter tmp;
        AggrMeter m = this.gauges.get(id);
        if (m == null && (m = this.gauges.putIfAbsent(id, tmp = new AggrMeter(id))) == null) {
            m = tmp;
        }
        return m;
    }

    <T extends Registry> T find(Class<T> c) {
        for (Registry r : this.registries) {
            if (!c.isAssignableFrom(r.getClass())) continue;
            return (T)r;
        }
        return null;
    }

    public void add(Registry registry) {
        this.registries.add(registry);
    }

    public void remove(Registry registry) {
        this.registries.remove(registry);
    }

    public void removeAll() {
        this.registries.clear();
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public Id createId(String name) {
        return new DefaultId(name);
    }

    @Override
    public Id createId(String name, Iterable<Tag> tags) {
        return new DefaultId(name, ArrayTagSet.create(tags));
    }

    @Override
    public void register(Meter meter) {
        AggrMeter m = this.computeIfAbsent(meter.id());
        m.add(meter);
    }

    @Override
    public Counter counter(Id id) {
        return new CompositeCounter(id, this.registries);
    }

    @Override
    public DistributionSummary distributionSummary(Id id) {
        return new CompositeDistributionSummary(id, this.registries);
    }

    @Override
    public Timer timer(Id id) {
        return new CompositeTimer(id, this.clock, this.registries);
    }

    @Override
    public Gauge gauge(Id id) {
        return new CompositeGauge(id, this.registries);
    }

    @Override
    public Meter get(Id id) {
        return new CompositeMeter(id, this.registries);
    }

    @Override
    public Iterator<Meter> iterator() {
        if (this.registries.isEmpty()) {
            return Collections.emptyList().iterator();
        }
        final HashSet<Id> ids = new HashSet<Id>();
        for (Registry r : this.registries) {
            for (Meter m : r) {
                ids.add(m.id());
            }
        }
        return new Iterator<Meter>(){
            private final Iterator<Id> idIter;
            {
                this.idIter = ids.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.idIter.hasNext();
            }

            @Override
            public Meter next() {
                return CompositeRegistry.this.get(this.idIter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

