/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.util.ArrayList;
import java.util.Collection;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Meter;
import spectator-agent.spectator.api.Registry;

class CompositeMeter
implements Meter {
    protected final Id id;
    protected final Collection<Registry> registries;

    public CompositeMeter(Id id, Collection<Registry> registries) {
        this.id = id;
        this.registries = registries;
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean hasExpired() {
        for (Registry r : this.registries) {
            Meter m = r.get(this.id);
            if (m == null || m.hasExpired()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterable<Measurement> measure() {
        ArrayList<Measurement> ms = new ArrayList<Measurement>();
        for (Registry r : this.registries) {
            Meter m = r.get(this.id);
            if (m == null) continue;
            for (Measurement measurement : m.measure()) {
                ms.add(measurement);
            }
        }
        return ms;
    }
}

