/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.function.Function;
import spectator-agent.slf4j.Logger;
import spectator-agent.slf4j.LoggerFactory;
import spectator-agent.spectator.api.AggrMeter;
import spectator-agent.spectator.api.ArrayTagSet;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.DefaultId;
import spectator-agent.spectator.api.DistributionSummary;
import spectator-agent.spectator.api.Gauge;
import spectator-agent.spectator.api.GaugePoller;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Meter;
import spectator-agent.spectator.api.NoopCounter;
import spectator-agent.spectator.api.NoopDistributionSummary;
import spectator-agent.spectator.api.NoopGauge;
import spectator-agent.spectator.api.NoopTimer;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.api.RegistryConfig;
import spectator-agent.spectator.api.Tag;
import spectator-agent.spectator.api.Timer;
import spectator-agent.spectator.impl.Config;
import spectator-agent.spectator.impl.Preconditions;

public abstract class AbstractRegistry
implements Registry {
    protected final Logger logger;
    private final Clock clock;
    private final RegistryConfig config;
    private final ConcurrentHashMap<Id, Meter> meters;
    private final ConcurrentHashMap<Id, Meter> gauges;
    private final Semaphore pollSem = new Semaphore(1);

    public AbstractRegistry(Clock clock) {
        this(clock, Config.defaultConfig());
    }

    public AbstractRegistry(Clock clock, RegistryConfig config) {
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.clock = clock;
        this.config = config;
        this.meters = new ConcurrentHashMap();
        this.gauges = new ConcurrentHashMap();
        GaugePoller.schedule(new WeakReference<Registry>(this), config.gaugePollingFrequency().toMillis(), AbstractRegistry::pollGauges);
    }

    protected abstract Counter newCounter(Id var1);

    protected abstract DistributionSummary newDistributionSummary(Id var1);

    protected abstract Timer newTimer(Id var1);

    protected abstract Gauge newGauge(Id var1);

    @Override
    public final Clock clock() {
        return this.clock;
    }

    @Override
    public final RegistryConfig config() {
        return this.config;
    }

    @Override
    public final Id createId(String name) {
        return new DefaultId(name);
    }

    @Override
    public final Id createId(String name, Iterable<Tag> tags) {
        return new DefaultId(name, ArrayTagSet.create(tags));
    }

    private void logTypeError(Id id, Class<?> desired, Class<?> found) {
        String dtype = desired.getName();
        String ftype = found.getName();
        String msg = String.format("cannot access '%s' as a %s, it already exists as a %s", id, dtype, ftype);
        this.propagate(new IllegalStateException(msg));
    }

    private void addToAggr(Meter aggr, Meter meter) {
        if (aggr instanceof AggrMeter) {
            ((AggrMeter)aggr).add(meter);
        } else {
            this.logTypeError(meter.id(), meter.getClass(), aggr.getClass());
        }
    }

    private Meter compute(Meter m, Meter fallback) {
        return this.meters.size() >= this.config.maxNumberOfMeters() ? fallback : m;
    }

    private Meter computeIfAbsent(ConcurrentHashMap<Id, Meter> map, Id id, Function<Id, Meter> f) {
        Meter tmp;
        Meter m = map.get(id);
        if (m == null && (m = map.putIfAbsent(id, tmp = f.apply(id))) == null) {
            m = tmp;
        }
        return m;
    }

    private void handleGaugeException(Id id, Throwable t) {
        this.logger.warn("dropping gauge [{}], exception occurred when polling value", (Object)id, (Object)t);
        this.gauges.remove(id);
    }

    private static void pollGauges(Registry r) {
        ((AbstractRegistry)r).pollGauges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pollGauges() {
        if (this.pollSem.tryAcquire()) {
            try {
                for (Map.Entry<Id, Meter> e : this.gauges.entrySet()) {
                    Id id = e.getKey();
                    Meter meter = e.getValue();
                    try {
                        if (meter.hasExpired()) continue;
                        for (Measurement m : meter.measure()) {
                            this.gauge(m.id()).set(m.value());
                        }
                    }
                    catch (StackOverflowError t) {
                        this.handleGaugeException(id, t);
                    }
                    catch (ThreadDeath | VirtualMachineError t) {
                        throw t;
                    }
                    catch (Throwable t) {
                        this.handleGaugeException(id, t);
                    }
                }
            }
            finally {
                this.pollSem.release();
            }
        }
    }

    @Override
    public void register(Meter meter) {
        Meter aggr;
        Meter meter2 = aggr = this.gauges.size() >= this.config.maxNumberOfMeters() ? this.meters.get(meter.id()) : this.computeIfAbsent(this.gauges, meter.id(), AggrMeter::new);
        if (aggr != null) {
            this.addToAggr(aggr, meter);
        }
    }

    @Override
    public final Counter counter(Id id) {
        try {
            Preconditions.checkNotNull(id, "id");
            Meter m = this.computeIfAbsent(this.meters, id, i -> this.compute(this.newCounter((Id)i), NoopCounter.INSTANCE));
            if (!(m instanceof Counter)) {
                this.logTypeError(id, Counter.class, m.getClass());
                m = NoopCounter.INSTANCE;
            }
            return (Counter)m;
        }
        catch (Exception e) {
            this.propagate(e);
            return NoopCounter.INSTANCE;
        }
    }

    @Override
    public final DistributionSummary distributionSummary(Id id) {
        try {
            Preconditions.checkNotNull(id, "id");
            Meter m = this.computeIfAbsent(this.meters, id, i -> this.compute(this.newDistributionSummary((Id)i), NoopDistributionSummary.INSTANCE));
            if (!(m instanceof DistributionSummary)) {
                this.logTypeError(id, DistributionSummary.class, m.getClass());
                m = NoopDistributionSummary.INSTANCE;
            }
            return (DistributionSummary)m;
        }
        catch (Exception e) {
            this.propagate(e);
            return NoopDistributionSummary.INSTANCE;
        }
    }

    @Override
    public final Timer timer(Id id) {
        try {
            Meter m = this.computeIfAbsent(this.meters, id, i -> this.compute(this.newTimer((Id)i), NoopTimer.INSTANCE));
            if (!(m instanceof Timer)) {
                this.logTypeError(id, Timer.class, m.getClass());
                m = NoopTimer.INSTANCE;
            }
            return (Timer)m;
        }
        catch (Exception e) {
            this.propagate(e);
            return NoopTimer.INSTANCE;
        }
    }

    @Override
    public final Gauge gauge(Id id) {
        try {
            Meter m = this.computeIfAbsent(this.meters, id, i -> this.compute(this.newGauge((Id)i), NoopGauge.INSTANCE));
            if (!(m instanceof Gauge)) {
                this.logTypeError(id, Gauge.class, m.getClass());
                m = NoopGauge.INSTANCE;
            }
            return (Gauge)m;
        }
        catch (Exception e) {
            this.propagate(e);
            return NoopGauge.INSTANCE;
        }
    }

    @Override
    public final Meter get(Id id) {
        return this.meters.get(id);
    }

    @Override
    public final Iterator<Meter> iterator() {
        this.pollGauges();
        return this.meters.values().iterator();
    }
}

