/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.agent;

import java.util.ArrayList;
import spectator-agent.slf4j.Logger;
import spectator-agent.slf4j.LoggerFactory;
import spectator-agent.spectator.agent.JmxConfig;
import spectator-agent.spectator.agent.JmxData;
import spectator-agent.spectator.agent.JmxMeasurementConfig;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Meter;
import spectator-agent.spectator.api.Registry;

final class JmxMeter
implements Meter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxMeter.class);
    private final Registry registry;
    private final JmxConfig config;
    private final Id id;

    JmxMeter(Registry registry, JmxConfig config) {
        this.registry = registry;
        this.config = config;
        this.id = registry.createId(config.getQuery().getCanonicalName());
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        ArrayList<Measurement> ms = new ArrayList<Measurement>();
        try {
            for (JmxData data : JmxData.query(this.config.getQuery())) {
                for (JmxMeasurementConfig cfg : this.config.getMeasurements()) {
                    cfg.measure(this.registry, data, ms);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("failed to query jmx data: {}", (Object)this.config.getQuery().getCanonicalName(), (Object)e);
        }
        return ms;
    }

    @Override
    public boolean hasExpired() {
        return false;
    }
}

