/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.agent;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import spectator-agent.config.Config;
import spectator-agent.spectator.agent.JmxData;
import spectator-agent.spectator.agent.MappingExpr;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Registry;

final class JmxMeasurementConfig {
    private final String nameMapping;
    private final Map<String, String> tagMappings;
    private final String valueMapping;
    private final boolean counter;
    private final Map<Id, AtomicLong> previous;

    static JmxMeasurementConfig from(Config config) {
        String name = config.getString("name");
        Map<String, String> tags = config.getConfigList("tags").stream().collect(Collectors.toMap(c -> c.getString("key"), c -> c.getString("value")));
        String value = config.getString("value");
        boolean counter = config.hasPath("counter") && config.getBoolean("counter");
        return new JmxMeasurementConfig(name, tags, value, counter);
    }

    JmxMeasurementConfig(String nameMapping, Map<String, String> tagMappings, String valueMapping, boolean counter) {
        this.nameMapping = nameMapping;
        this.tagMappings = tagMappings;
        this.valueMapping = valueMapping;
        this.counter = counter;
        this.previous = new ConcurrentHashMap<Id, AtomicLong>();
    }

    void measure(Registry registry, JmxData data, List<Measurement> ms) {
        Map<String, String> tags = this.tagMappings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> MappingExpr.substitute((String)e.getValue(), data.getStringAttrs())));
        Id id = registry.createId(MappingExpr.substitute(this.nameMapping, data.getStringAttrs())).withTags(tags);
        Double v = MappingExpr.eval(this.valueMapping, data.getNumberAttrs());
        if (v != null) {
            if (this.counter) {
                this.updateCounter(registry, id, v.longValue());
            } else {
                ms.add(new Measurement(id, registry.clock().wallTime(), v));
            }
        }
    }

    private void updateCounter(Registry registry, Id id, long v) {
        long p;
        AtomicLong prev = this.previous.computeIfAbsent(id, i -> new AtomicLong(0L));
        if (prev.compareAndSet(p = prev.get(), v) && p != 0L) {
            registry.counter(id).increment(v - p);
        }
    }
}

