/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.json.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.sql.Date;
import java.text.DateFormat;
import spectator-agent.json.jackson.core.JsonGenerationException;
import spectator-agent.json.jackson.core.JsonGenerator;
import spectator-agent.json.jackson.databind.JavaType;
import spectator-agent.json.jackson.databind.JsonMappingException;
import spectator-agent.json.jackson.databind.JsonNode;
import spectator-agent.json.jackson.databind.SerializerProvider;
import spectator-agent.json.jackson.databind.annotation.JacksonStdImpl;
import spectator-agent.json.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import spectator-agent.json.jackson.databind.ser.std.DateTimeSerializerBase;

@JacksonStdImpl
public class SqlDateSerializer
extends DateTimeSerializerBase<Date> {
    public SqlDateSerializer() {
        this(Boolean.FALSE);
    }

    protected SqlDateSerializer(Boolean useTimestamp) {
        super(Date.class, useTimestamp, null);
    }

    public SqlDateSerializer withFormat(Boolean timestamp, DateFormat customFormat) {
        return new SqlDateSerializer(timestamp);
    }

    @Override
    protected long _timestamp(Date value) {
        return value == null ? 0L : value.getTime();
    }

    @Override
    public void serialize(Date value, JsonGenerator gen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._asTimestamp(provider)) {
            gen.writeNumber(this._timestamp(value));
        } else {
            gen.writeString(value.toString());
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this._acceptJsonFormatVisitor(visitor, typeHint, this._useTimestamp);
    }
}

