/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.json.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import spectator-agent.json.jackson.core.JsonGenerator;
import spectator-agent.json.jackson.databind.JavaType;
import spectator-agent.json.jackson.databind.JsonMappingException;
import spectator-agent.json.jackson.databind.JsonNode;
import spectator-agent.json.jackson.databind.SerializerProvider;
import spectator-agent.json.jackson.databind.annotation.JacksonStdImpl;
import spectator-agent.json.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import spectator-agent.json.jackson.databind.ser.std.NonTypedScalarSerializerBase;

@JacksonStdImpl
public final class BooleanSerializer
extends NonTypedScalarSerializerBase<Boolean> {
    private static final long serialVersionUID = 1L;
    protected final boolean _forPrimitive;

    public BooleanSerializer(boolean forPrimitive) {
        super(Boolean.class);
        this._forPrimitive = forPrimitive;
    }

    @Override
    public void serialize(Boolean value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeBoolean(value);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("boolean", !this._forPrimitive);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        if (visitor != null) {
            visitor.expectBooleanFormat(typeHint);
        }
    }
}

