/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.json.jackson.databind.ser;

import java.util.Map;
import spectator-agent.json.jackson.core.JsonGenerator;
import spectator-agent.json.jackson.databind.BeanProperty;
import spectator-agent.json.jackson.databind.JsonMappingException;
import spectator-agent.json.jackson.databind.JsonSerializer;
import spectator-agent.json.jackson.databind.MapperFeature;
import spectator-agent.json.jackson.databind.SerializationConfig;
import spectator-agent.json.jackson.databind.SerializerProvider;
import spectator-agent.json.jackson.databind.introspect.AnnotatedMember;
import spectator-agent.json.jackson.databind.ser.ContextualSerializer;
import spectator-agent.json.jackson.databind.ser.PropertyFilter;
import spectator-agent.json.jackson.databind.ser.std.MapSerializer;

public class AnyGetterWriter {
    protected final BeanProperty _property;
    protected final AnnotatedMember _accessor;
    protected JsonSerializer<Object> _serializer;
    protected MapSerializer _mapSerializer;

    public AnyGetterWriter(BeanProperty property, AnnotatedMember accessor, JsonSerializer<?> serializer) {
        this._accessor = accessor;
        this._property = property;
        this._serializer = serializer;
        if (serializer instanceof MapSerializer) {
            this._mapSerializer = (MapSerializer)serializer;
        }
    }

    public void fixAccess(SerializationConfig config) {
        this._accessor.fixAccess(config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
    }

    public void getAndSerialize(Object bean, JsonGenerator gen, SerializerProvider provider) throws Exception {
        Object value = this._accessor.getValue(bean);
        if (value == null) {
            return;
        }
        if (!(value instanceof Map)) {
            provider.reportMappingProblem("Value returned by 'any-getter' %s() not java.util.Map but %s", this._accessor.getName(), value.getClass().getName());
        }
        if (this._mapSerializer != null) {
            this._mapSerializer.serializeFields((Map)value, gen, provider);
            return;
        }
        this._serializer.serialize(value, gen, provider);
    }

    public void getAndFilter(Object bean, JsonGenerator gen, SerializerProvider provider, PropertyFilter filter) throws Exception {
        Object value = this._accessor.getValue(bean);
        if (value == null) {
            return;
        }
        if (!(value instanceof Map)) {
            provider.reportMappingProblem("Value returned by 'any-getter' (%s()) not java.util.Map but %s", this._accessor.getName(), value.getClass().getName());
        }
        if (this._mapSerializer != null) {
            this._mapSerializer.serializeFilteredFields((Map)value, gen, provider, filter, null);
            return;
        }
        this._serializer.serialize(value, gen, provider);
    }

    public void resolve(SerializerProvider provider) throws JsonMappingException {
        if (this._serializer instanceof ContextualSerializer) {
            JsonSerializer<?> ser = provider.handlePrimaryContextualization(this._serializer, this._property);
            this._serializer = ser;
            if (ser instanceof MapSerializer) {
                this._mapSerializer = (MapSerializer)ser;
            }
        }
    }
}

