/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.agent;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;

class JmxData {
    private final ObjectName name;
    private final Map<String, String> stringAttrs;
    private final Map<String, Number> numberAttrs;

    static List<JmxData> query(String query) throws Exception {
        return JmxData.query(new ObjectName(query));
    }

    static List<JmxData> query(ObjectName query) throws Exception {
        return JmxData.query(ManagementFactory.getPlatformMBeanServer(), query);
    }

    static List<JmxData> query(MBeanServer server, ObjectName query) throws Exception {
        ArrayList<JmxData> data = new ArrayList<JmxData>();
        Set<ObjectName> names = server.queryNames(query, null);
        for (ObjectName name : names) {
            MBeanInfo info = server.getMBeanInfo(name);
            MBeanAttributeInfo[] attrs = info.getAttributes();
            String[] attrNames = new String[attrs.length];
            for (int i = 0; i < attrs.length; ++i) {
                attrNames[i] = attrs[i].getName();
            }
            HashMap<String, String> stringAttrs = new HashMap<String, String>(name.getKeyPropertyList());
            stringAttrs.put("domain", name.getDomain());
            HashMap<String, Number> numberAttrs = new HashMap<String, Number>();
            for (Attribute attr : server.getAttributes(name, attrNames).asList()) {
                Object obj = attr.getValue();
                if (obj instanceof String) {
                    stringAttrs.put(attr.getName(), (String)obj);
                    continue;
                }
                if (obj instanceof Number) {
                    numberAttrs.put(attr.getName(), ((Number)obj).doubleValue());
                    continue;
                }
                if (!(obj instanceof TimeUnit)) continue;
                stringAttrs.put(attr.getName(), obj.toString());
            }
            data.add(new JmxData(name, stringAttrs, numberAttrs));
        }
        return data;
    }

    JmxData(ObjectName name, Map<String, String> stringAttrs, Map<String, Number> numberAttrs) {
        this.name = name;
        this.stringAttrs = stringAttrs;
        this.numberAttrs = numberAttrs;
    }

    ObjectName getName() {
        return this.name;
    }

    Map<String, String> getStringAttrs() {
        return this.stringAttrs;
    }

    Map<String, Number> getNumberAttrs() {
        return this.numberAttrs;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append(this.name.toString()).append("\n- string attributes\n");
        for (Map.Entry<String, String> entry : new TreeMap<String, String>(this.stringAttrs).entrySet()) {
            buf.append("  - ").append(entry.getKey()).append(" = ").append(entry.getValue()).append('\n');
        }
        buf.append("- number attributes\n");
        for (Map.Entry<String, Object> entry : new TreeMap<String, Number>(this.numberAttrs).entrySet()) {
            buf.append("  - ").append(entry.getKey()).append(" = ").append(entry.getValue()).append('\n');
        }
        return buf.toString();
    }
}

