/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.util.Map;
import spectator-agent.spectator.api.Tag;

public interface Id {
    public String name();

    public Iterable<Tag> tags();

    public Id withTag(String var1, String var2);

    public Id withTag(Tag var1);

    default public Id withTags(String ... tags) {
        Id tmp = this;
        for (int i = 0; i < tags.length; i += 2) {
            tmp = tmp.withTag(tags[i], tags[i + 1]);
        }
        return tmp;
    }

    default public Id withTags(Tag ... tags) {
        Id tmp = this;
        for (Tag t : tags) {
            tmp = tmp.withTag(t);
        }
        return tmp;
    }

    default public Id withTags(Iterable<Tag> tags) {
        Id tmp = this;
        for (Tag t : tags) {
            tmp = tmp.withTag(t);
        }
        return tmp;
    }

    default public Id withTags(Map<String, String> tags) {
        Id tmp = this;
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            tmp = tmp.withTag(entry.getKey(), entry.getValue());
        }
        return tmp;
    }
}

