/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.util.Collection;
import java.util.Iterator;
import spectator-agent.spectator.api.CompositeMeter;
import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Registry;

final class CompositeCounter
extends CompositeMeter
implements Counter {
    CompositeCounter(Id id, Collection<Registry> registries) {
        super(id, registries);
    }

    @Override
    public void increment() {
        for (Registry r : this.registries) {
            r.counter(this.id).increment();
        }
    }

    @Override
    public void increment(long amount) {
        for (Registry r : this.registries) {
            r.counter(this.id).increment(amount);
        }
    }

    @Override
    public long count() {
        Iterator it = this.registries.iterator();
        return it.hasNext() ? ((Registry)it.next()).counter(this.id).count() : 0L;
    }
}

