/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Meter;

class AggrMeter
implements Meter {
    private final Id id;
    private final ConcurrentLinkedQueue<Meter> queue;

    AggrMeter(Id id) {
        this.id = id;
        this.queue = new ConcurrentLinkedQueue();
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        HashMap<Id, Measurement> measurements = new HashMap<Id, Measurement>();
        Iterator<Meter> iter = this.queue.iterator();
        while (iter.hasNext()) {
            Meter meter = iter.next();
            if (meter.hasExpired()) {
                iter.remove();
                continue;
            }
            for (Measurement m : meter.measure()) {
                Measurement prev = (Measurement)measurements.get(m.id());
                if (prev == null) {
                    measurements.put(m.id(), m);
                    continue;
                }
                double v = prev.value() + m.value();
                measurements.put(prev.id(), new Measurement(prev.id(), prev.timestamp(), v));
            }
        }
        return measurements.values();
    }

    @Override
    public boolean hasExpired() {
        return this.queue.isEmpty();
    }

    void add(Meter m) {
        this.queue.add(m);
    }
}

