/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.agent;

import java.lang.instrument.Instrumentation;
import java.util.HashMap;
import java.util.Map;
import spectator-agent.config.Config;
import spectator-agent.config.ConfigFactory;
import spectator-agent.spectator.agent.JmxConfig;
import spectator-agent.spectator.agent.JmxMeter;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Spectator;
import spectator-agent.spectator.atlas.AtlasConfig;
import spectator-agent.spectator.atlas.AtlasRegistry;
import spectator-agent.spectator.gc.GcLogger;
import spectator-agent.spectator.jvm.Jmx;

public final class Agent {
    private Agent() {
    }

    private static Config loadConfig(String userResources) {
        Config config = ConfigFactory.load("agent");
        if (userResources != null && !"".equals(userResources)) {
            for (String userResource : userResources.split("[,\\s]+]")) {
                Config user = ConfigFactory.load(userResource);
                config = user.withFallback(config);
            }
        }
        return config.getConfig("netflix.spectator.agent");
    }

    public static void premain(String arg, Instrumentation instrumentation) throws Exception {
        Config config = Agent.loadConfig(arg);
        AtlasRegistry registry = new AtlasRegistry(Clock.SYSTEM, new AgentAtlasConfig(config));
        Spectator.globalRegistry().add(registry);
        GcLogger gcLogger = new GcLogger();
        if (config.getBoolean("collection.gc")) {
            gcLogger.start(null);
        }
        if (config.getBoolean("collection.jvm")) {
            Jmx.registerStandardMXBeans(registry);
        }
        if (config.getBoolean("collection.jmx")) {
            for (Config config2 : config.getConfigList("jmx.mappings")) {
                registry.register(new JmxMeter(registry, JmxConfig.from(config2)));
            }
        }
        registry.start();
        Runtime.getRuntime().addShutdownHook(new Thread(registry::stop, "spectator-agent-shutdown"));
    }

    private static class AgentAtlasConfig
    implements AtlasConfig {
        private final Config config;

        AgentAtlasConfig(Config config) {
            this.config = config;
        }

        @Override
        public String get(String k) {
            return this.config.hasPath(k) ? this.config.getString(k) : null;
        }

        @Override
        public Map<String, String> commonTags() {
            HashMap<String, String> tags = new HashMap<String, String>();
            for (Config config : this.config.getConfigList("atlas.tags")) {
                String value = config.getString("value");
                if (value.isEmpty()) continue;
                tags.put(config.getString("key"), config.getString("value"));
            }
            return tags;
        }
    }
}

