/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.json.jackson.databind.ser.std;

import java.io.IOException;
import java.nio.ByteBuffer;
import spectator-agent.json.jackson.core.JsonGenerator;
import spectator-agent.json.jackson.databind.SerializerProvider;
import spectator-agent.json.jackson.databind.ser.std.StdScalarSerializer;
import spectator-agent.json.jackson.databind.util.ByteBufferBackedInputStream;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer bbuf, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (bbuf.hasArray()) {
            gen.writeBinary(bbuf.array(), 0, bbuf.limit());
            return;
        }
        ByteBuffer copy = bbuf.asReadOnlyBuffer();
        if (copy.position() > 0) {
            copy.rewind();
        }
        ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(copy);
        gen.writeBinary(in, copy.remaining());
        in.close();
    }
}

