/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import spectator-agent.json.jackson.databind.ObjectMapper;
import spectator-agent.json.jackson.databind.module.SimpleModule;
import spectator-agent.json.jackson.dataformat.smile.SmileFactory;
import spectator-agent.slf4j.Logger;
import spectator-agent.slf4j.LoggerFactory;
import spectator-agent.spectator.api.AbstractRegistry;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.DistributionSummary;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Timer;
import spectator-agent.spectator.atlas.AtlasConfig;
import spectator-agent.spectator.atlas.AtlasCounter;
import spectator-agent.spectator.atlas.AtlasDistributionSummary;
import spectator-agent.spectator.atlas.AtlasTimer;
import spectator-agent.spectator.atlas.MeasurementSerializer;
import spectator-agent.spectator.atlas.PublishPayload;
import spectator-agent.spectator.atlas.StepClock;
import spectator-agent.spectator.impl.Scheduler;
import spectator-agent.spectator.sandbox.HttpClient;
import spectator-agent.spectator.sandbox.HttpResponse;

public final class AtlasRegistry
extends AbstractRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtlasRegistry.class);
    private static final String CLOCK_SKEW_TIMER = "spectator.atlas.clockSkew";
    private final Clock clock;
    private final Duration step;
    private final long stepMillis;
    private final URI uri;
    private final int connectTimeout;
    private final int readTimeout;
    private final int batchSize;
    private final int numThreads;
    private final Map<String, String> commonTags;
    private Scheduler scheduler;
    private final ObjectMapper mapper;

    public AtlasRegistry(Clock clock, AtlasConfig config) {
        super(new StepClock(clock, config.step().toMillis()), config);
        this.clock = clock;
        this.step = config.step();
        this.stepMillis = this.step.toMillis();
        this.uri = URI.create(config.uri());
        this.connectTimeout = (int)config.connectTimeout().toMillis();
        this.readTimeout = (int)config.readTimeout().toMillis();
        this.batchSize = config.batchSize();
        this.numThreads = config.numThreads();
        this.commonTags = new TreeMap<String, String>(config.commonTags());
        SimpleModule module = new SimpleModule().addSerializer(Measurement.class, new MeasurementSerializer());
        this.mapper = new ObjectMapper(new SmileFactory()).registerModule(module);
    }

    public void start() {
        if (this.scheduler == null) {
            Scheduler.Options options = new Scheduler.Options().withFrequency(Scheduler.Policy.FIXED_RATE_SKIP_IF_LONG, this.step).withInitialDelay(Duration.ofMillis(this.getInitialDelay(this.stepMillis))).withStopOnFailure(false);
            this.scheduler = new Scheduler(this, "atlas-registry", this.numThreads);
            this.scheduler.schedule(options, this::collectData);
            LOGGER.info("started collecting metrics every {} reporting to {}", (Object)this.step, (Object)this.uri);
            LOGGER.info("common tags: {}", (Object)this.commonTags);
        } else {
            LOGGER.warn("registry already started, ignoring duplicate request");
        }
    }

    long getInitialDelay(long stepSize) {
        long offset;
        long stepBoundary;
        long now = this.clock.wallTime();
        long delay = now - (stepBoundary = now / stepSize * stepSize);
        if (delay < (offset = stepSize / 10L)) {
            return delay + offset;
        }
        if (delay > stepSize - offset) {
            return stepSize - offset;
        }
        return delay;
    }

    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            this.scheduler = null;
            LOGGER.info("stopped collecting metrics every {}ms reporting to {}", (Object)this.step, (Object)this.uri);
        } else {
            LOGGER.warn("registry stopped, but was never started");
        }
    }

    private void collectData() {
        try {
            for (List<Measurement> batch : this.getBatches()) {
                PublishPayload p = new PublishPayload(this.commonTags, batch);
                HttpResponse res = HttpClient.DEFAULT.newRequest("spectator-reg-atlas", this.uri).withMethod("POST").withConnectTimeout(this.connectTimeout).withReadTimeout(this.readTimeout).withContent("application/x-jackson-smile", this.mapper.writeValueAsBytes(p)).send();
                Instant date = res.dateHeader("Date");
                this.recordClockSkew(date == null ? 0L : date.toEpochMilli());
            }
        }
        catch (Exception e) {
            LOGGER.warn("failed to send metrics", e);
        }
    }

    private void recordClockSkew(long responseTimestamp) {
        if (responseTimestamp == 0L) {
            LOGGER.debug("no date timestamp on response, cannot record skew");
        } else {
            long delta = this.clock.wallTime() - responseTimestamp;
            if (delta >= 0L) {
                this.timer(CLOCK_SKEW_TIMER, "id", "fast").record(delta, TimeUnit.MILLISECONDS);
            } else {
                this.timer(CLOCK_SKEW_TIMER, "id", "slow").record(-delta, TimeUnit.MILLISECONDS);
            }
            LOGGER.debug("clock skew between client and server: {}ms", (Object)delta);
        }
    }

    List<Measurement> getMeasurements() {
        return this.stream().flatMap(m -> StreamSupport.stream(m.measure().spliterator(), false)).collect(Collectors.toList());
    }

    List<List<Measurement>> getBatches() {
        ArrayList<List<Measurement>> batches = new ArrayList<List<Measurement>>();
        List<Measurement> ms = this.getMeasurements();
        for (int i = 0; i < ms.size(); i += this.batchSize) {
            List<Measurement> batch = ms.subList(i, Math.min(ms.size(), i + this.batchSize));
            batches.add(batch);
        }
        return batches;
    }

    @Override
    protected Counter newCounter(Id id) {
        return new AtlasCounter(id, this.clock, this.stepMillis);
    }

    @Override
    protected DistributionSummary newDistributionSummary(Id id) {
        return new AtlasDistributionSummary(id, this.clock, this.stepMillis);
    }

    @Override
    protected Timer newTimer(Id id) {
        return new AtlasTimer(id, this.clock, this.stepMillis);
    }
}

