/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import java.util.Collections;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.atlas.DsType;
import spectator-agent.spectator.impl.StepLong;

class AtlasCounter
implements Counter {
    private final Id id;
    private final StepLong value;
    private final Id stat;

    AtlasCounter(Id id, Clock clock, long step) {
        this.id = id;
        this.value = new StepLong(0L, clock, step);
        this.stat = id.withTag(DsType.rate);
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public Iterable<Measurement> measure() {
        double rate = this.value.pollAsRate();
        Measurement m = new Measurement(this.stat, this.value.timestamp(), rate);
        return Collections.singletonList(m);
    }

    @Override
    public void increment() {
        this.value.getCurrent().incrementAndGet();
    }

    @Override
    public void increment(long amount) {
        this.value.getCurrent().addAndGet(amount);
    }

    @Override
    public long count() {
        return this.value.poll();
    }
}

