/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.util.ArrayList;
import spectator-agent.spectator.api.DefaultRegistry;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Meter;
import spectator-agent.spectator.api.Registry;

class RegistryMeter
implements Meter {
    private final Id id;
    private final Registry registry;

    RegistryMeter(Id id) {
        this(id, new DefaultRegistry());
    }

    RegistryMeter(Id id, Registry registry) {
        this.id = id;
        this.registry = registry;
    }

    void register(Meter meter) {
        this.registry.register(meter);
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        ArrayList<Measurement> ms = new ArrayList<Measurement>();
        for (Meter m : this.registry) {
            try {
                for (Measurement measurement : m.measure()) {
                    ms.add(measurement);
                }
            }
            catch (Exception | LinkageError e) {
                this.registry.propagate("failed to measure " + m.id(), e);
            }
        }
        return ms;
    }

    @Override
    public boolean hasExpired() {
        return false;
    }
}

