/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.ToDoubleFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import spectator-agent.slf4j.LoggerFactory;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.CompositeRegistry;
import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.DefaultLongTaskTimer;
import spectator-agent.spectator.api.DistributionSummary;
import spectator-agent.spectator.api.Functions;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.LongTaskTimer;
import spectator-agent.spectator.api.Meter;
import spectator-agent.spectator.api.ObjectGauge;
import spectator-agent.spectator.api.RegistryConfig;
import spectator-agent.spectator.api.Tag;
import spectator-agent.spectator.api.Timer;
import spectator-agent.spectator.api.Utils;
import spectator-agent.spectator.impl.Config;

public interface Registry
extends Iterable<Meter> {
    public Clock clock();

    default public RegistryConfig config() {
        return Config.defaultConfig();
    }

    public Id createId(String var1);

    public Id createId(String var1, Iterable<Tag> var2);

    public void register(Meter var1);

    public Counter counter(Id var1);

    public DistributionSummary distributionSummary(Id var1);

    public Timer timer(Id var1);

    public Meter get(Id var1);

    @Override
    public Iterator<Meter> iterator();

    default public <T extends Registry> T underlying(Class<T> c) {
        if (c.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (this instanceof CompositeRegistry) {
            return ((CompositeRegistry)this).find(c);
        }
        return null;
    }

    default public Id createId(String name, String ... tags) {
        return this.createId(name, Utils.toIterable(tags));
    }

    default public Id createId(String name, Map<String, String> tags) {
        return this.createId(name).withTags(tags);
    }

    default public Counter counter(String name) {
        return this.counter(this.createId(name));
    }

    default public Counter counter(String name, Iterable<Tag> tags) {
        return this.counter(this.createId(name, tags));
    }

    default public Counter counter(String name, String ... tags) {
        return this.counter(this.createId(name, Utils.toIterable(tags)));
    }

    default public DistributionSummary distributionSummary(String name) {
        return this.distributionSummary(this.createId(name));
    }

    default public DistributionSummary distributionSummary(String name, Iterable<Tag> tags) {
        return this.distributionSummary(this.createId(name, tags));
    }

    default public DistributionSummary distributionSummary(String name, String ... tags) {
        return this.distributionSummary(this.createId(name, Utils.toIterable(tags)));
    }

    default public Timer timer(String name) {
        return this.timer(this.createId(name));
    }

    default public Timer timer(String name, Iterable<Tag> tags) {
        return this.timer(this.createId(name, tags));
    }

    default public Timer timer(String name, String ... tags) {
        return this.timer(this.createId(name, Utils.toIterable(tags)));
    }

    default public LongTaskTimer longTaskTimer(Id id) {
        DefaultLongTaskTimer taskTimer = new DefaultLongTaskTimer(this.clock(), id);
        this.register(taskTimer);
        return taskTimer;
    }

    default public LongTaskTimer longTaskTimer(String name) {
        return this.longTaskTimer(this.createId(name));
    }

    default public LongTaskTimer longTaskTimer(String name, Iterable<Tag> tags) {
        return this.longTaskTimer(this.createId(name, tags));
    }

    default public LongTaskTimer longTaskTimer(String name, String ... tags) {
        return this.longTaskTimer(this.createId(name, Utils.toIterable(tags)));
    }

    default public <T extends Number> T gauge(Id id, T number) {
        return (T)this.gauge(id, number, Number::doubleValue);
    }

    default public <T extends Number> T gauge(String name, T number) {
        return this.gauge(this.createId(name), number);
    }

    default public <T extends Number> T gauge(String name, Iterable<Tag> tags, T number) {
        return this.gauge(this.createId(name, tags), number);
    }

    default public <T> T gauge(Id id, T obj, ToDoubleFunction<T> f) {
        this.register(new ObjectGauge<T>(this.clock(), id, obj, f));
        return obj;
    }

    default public <T> T gauge(String name, T obj, ToDoubleFunction<T> f) {
        return this.gauge(this.createId(name), obj, f);
    }

    default public <T extends Collection<?>> T collectionSize(Id id, T collection) {
        return (T)this.gauge(id, collection, Collection::size);
    }

    default public <T extends Collection<?>> T collectionSize(String name, T collection) {
        return this.collectionSize(this.createId(name), collection);
    }

    default public <T extends Map<?, ?>> T mapSize(Id id, T collection) {
        return (T)this.gauge(id, collection, Map::size);
    }

    default public <T extends Map<?, ?>> T mapSize(String name, T collection) {
        return this.mapSize(this.createId(name), collection);
    }

    default public void methodValue(Id id, Object obj, String method) {
        Method m = Utils.getGaugeMethod(this, id, obj, method);
        if (m != null) {
            this.gauge(id, obj, Functions.invokeMethod(m));
        }
    }

    default public void methodValue(String name, Object obj, String method) {
        this.methodValue(this.createId(name), obj, method);
    }

    default public Stream<Meter> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public Stream<Counter> counters() {
        return this.stream().filter(m -> m instanceof Counter).map(m -> (Counter)m);
    }

    default public Stream<DistributionSummary> distributionSummaries() {
        return this.stream().filter(m -> m instanceof DistributionSummary).map(m -> (DistributionSummary)m);
    }

    default public Stream<Timer> timers() {
        return this.stream().filter(m -> m instanceof Timer).map(m -> (Timer)m);
    }

    default public void propagate(String msg, Throwable t) {
        LoggerFactory.getLogger(this.getClass()).warn(msg, t);
        if (this.config().propagateWarnings()) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    default public void propagate(Throwable t) {
        this.propagate(t.getMessage(), t);
    }
}

