/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArraySet;
import spectator-agent.spectator.api.ArrayTagSet;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.CompositeCounter;
import spectator-agent.spectator.api.CompositeDistributionSummary;
import spectator-agent.spectator.api.CompositeMeter;
import spectator-agent.spectator.api.CompositeTimer;
import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.DefaultId;
import spectator-agent.spectator.api.DistributionSummary;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Meter;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.api.RegistryMeter;
import spectator-agent.spectator.api.Tag;
import spectator-agent.spectator.api.Timer;

public final class CompositeRegistry
implements Registry {
    static final Id GAUGES_ID = new DefaultId("spectator.composite.gauges");
    private final Clock clock;
    private final CopyOnWriteArraySet<Registry> registries;
    private final RegistryMeter gauges;

    CompositeRegistry(Clock clock) {
        this.clock = clock;
        this.registries = new CopyOnWriteArraySet();
        this.gauges = new RegistryMeter(GAUGES_ID);
    }

    <T extends Registry> T find(Class<T> c) {
        for (Registry r : this.registries) {
            if (!c.isAssignableFrom(r.getClass())) continue;
            return (T)r;
        }
        return null;
    }

    public void add(Registry registry) {
        this.registries.add(registry);
        registry.register(this.gauges);
    }

    public void remove(Registry registry) {
        this.registries.remove(registry);
    }

    public void removeAll() {
        this.registries.clear();
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public Id createId(String name) {
        return new DefaultId(name);
    }

    @Override
    public Id createId(String name, Iterable<Tag> tags) {
        return new DefaultId(name, ArrayTagSet.create(tags));
    }

    @Override
    public void register(Meter meter) {
        this.gauges.register(meter);
    }

    @Override
    public Counter counter(Id id) {
        return new CompositeCounter(id, this.registries);
    }

    @Override
    public DistributionSummary distributionSummary(Id id) {
        return new CompositeDistributionSummary(id, this.registries);
    }

    @Override
    public Timer timer(Id id) {
        return new CompositeTimer(id, this.clock, this.registries);
    }

    @Override
    public Meter get(Id id) {
        return new CompositeMeter(id, this.registries);
    }

    @Override
    public Iterator<Meter> iterator() {
        if (this.registries.isEmpty()) {
            return Collections.emptyList().iterator();
        }
        final HashSet<Id> ids = new HashSet<Id>();
        for (Registry r : this.registries) {
            for (Meter m : r) {
                ids.add(m.id());
            }
        }
        return new Iterator<Meter>(){
            private final Iterator<Id> idIter;
            {
                this.idIter = ids.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.idIter.hasNext();
            }

            @Override
            public Meter next() {
                return CompositeRegistry.this.get(this.idIter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

