/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.agent;

import java.beans.Introspector;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.function.DoubleBinaryOperator;

final class MappingExpr {
    private MappingExpr() {
    }

    static String substitute(String pattern, Map<String, String> vars) {
        String value = pattern;
        for (Map.Entry<String, String> entry : vars.entrySet()) {
            String v = Introspector.decapitalize(entry.getValue());
            value = value.replace("{" + entry.getKey() + "}", v);
        }
        return value;
    }

    static Double eval(String expr, Map<String, ? extends Number> vars) {
        String[] parts;
        ArrayDeque<Double> stack = new ArrayDeque<Double>();
        String[] stringArray = parts = expr.split("[,\\s]+");
        int n = stringArray.length;
        block12: for (int i = 0; i < n; ++i) {
            String part;
            switch (part = stringArray[i]) {
                case ":add": {
                    MappingExpr.binaryOp(stack, (a, b) -> a + b);
                    continue block12;
                }
                case ":sub": {
                    MappingExpr.binaryOp(stack, (a, b) -> a - b);
                    continue block12;
                }
                case ":mul": {
                    MappingExpr.binaryOp(stack, (a, b) -> a * b);
                    continue block12;
                }
                case ":div": {
                    MappingExpr.binaryOp(stack, (a, b) -> a / b);
                    continue block12;
                }
                default: {
                    if (part.startsWith("{") && part.endsWith("}")) {
                        Number v = vars.get(part.substring(1, part.length() - 1));
                        if (v == null) {
                            return null;
                        }
                        stack.addFirst(v.doubleValue());
                        continue block12;
                    }
                    stack.addFirst(Double.parseDouble(part));
                }
            }
        }
        return (Double)stack.removeFirst();
    }

    private static void binaryOp(Deque<Double> stack, DoubleBinaryOperator op) {
        double b = stack.removeFirst();
        double a = stack.removeFirst();
        stack.addFirst(op.applyAsDouble(a, b));
    }
}

