/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.json.jackson.databind.deser.impl;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import spectator-agent.json.jackson.core.JsonParser;
import spectator-agent.json.jackson.core.JsonToken;
import spectator-agent.json.jackson.databind.DeserializationConfig;
import spectator-agent.json.jackson.databind.DeserializationContext;
import spectator-agent.json.jackson.databind.JsonDeserializer;
import spectator-agent.json.jackson.databind.PropertyName;
import spectator-agent.json.jackson.databind.deser.SettableBeanProperty;
import spectator-agent.json.jackson.databind.introspect.AnnotatedConstructor;
import spectator-agent.json.jackson.databind.introspect.AnnotatedMember;
import spectator-agent.json.jackson.databind.util.ClassUtil;

public final class InnerClassProperty
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final SettableBeanProperty _delegate;
    protected final transient Constructor<?> _creator;
    protected AnnotatedConstructor _annotated;

    public InnerClassProperty(SettableBeanProperty delegate, Constructor<?> ctor) {
        super(delegate);
        this._delegate = delegate;
        this._creator = ctor;
    }

    protected InnerClassProperty(InnerClassProperty src, AnnotatedConstructor ann) {
        super(src);
        this._delegate = src._delegate;
        this._annotated = ann;
        Constructor<?> constructor = this._creator = this._annotated == null ? null : this._annotated.getAnnotated();
        if (this._creator == null) {
            throw new IllegalArgumentException("Missing constructor (broken JDK (de)serialization?)");
        }
    }

    protected InnerClassProperty(InnerClassProperty src, JsonDeserializer<?> deser) {
        super((SettableBeanProperty)src, deser);
        this._delegate = src._delegate.withValueDeserializer(deser);
        this._creator = src._creator;
    }

    protected InnerClassProperty(InnerClassProperty src, PropertyName newName) {
        super((SettableBeanProperty)src, newName);
        this._delegate = src._delegate.withName(newName);
        this._creator = src._creator;
    }

    @Override
    public InnerClassProperty withName(PropertyName newName) {
        return new InnerClassProperty(this, newName);
    }

    @Override
    public InnerClassProperty withValueDeserializer(JsonDeserializer<?> deser) {
        return new InnerClassProperty(this, deser);
    }

    @Override
    public void fixAccess(DeserializationConfig config) {
        this._delegate.fixAccess(config);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._delegate.getAnnotation(acls);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._delegate.getMember();
    }

    @Override
    public void deserializeAndSet(JsonParser jp, DeserializationContext ctxt, Object bean) throws IOException {
        Object value;
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NULL) {
            value = this._valueDeserializer.getNullValue(ctxt);
        } else if (this._valueTypeDeserializer != null) {
            value = this._valueDeserializer.deserializeWithType(jp, ctxt, this._valueTypeDeserializer);
        } else {
            try {
                value = this._creator.newInstance(bean);
            }
            catch (Exception e) {
                ClassUtil.unwrapAndThrowAsIAE(e, "Failed to instantiate class " + this._creator.getDeclaringClass().getName() + ", problem: " + e.getMessage());
                value = null;
            }
            this._valueDeserializer.deserialize(jp, ctxt, value);
        }
        this.set(bean, value);
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser jp, DeserializationContext ctxt, Object instance) throws IOException {
        return this.setAndReturn(instance, this.deserialize(jp, ctxt));
    }

    @Override
    public final void set(Object instance, Object value) throws IOException {
        this._delegate.set(instance, value);
    }

    @Override
    public Object setAndReturn(Object instance, Object value) throws IOException {
        return this._delegate.setAndReturn(instance, value);
    }

    Object readResolve() {
        return new InnerClassProperty(this, this._annotated);
    }

    Object writeReplace() {
        if (this._annotated != null) {
            return this;
        }
        return new InnerClassProperty(this, new AnnotatedConstructor(null, this._creator, null, null));
    }
}

