/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.util.Memoizer;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

class MonitoredCache {
    private static final int CACHE_TIME = 10;
    private final Memoizer<CacheStats> memoStats;

    MonitoredCache(final Cache<?, ?> cache) {
        Callable<CacheStats> supplier = new Callable<CacheStats>(){

            @Override
            public CacheStats call() throws Exception {
                return cache.stats();
            }
        };
        this.memoStats = Memoizer.create(supplier, 10L, TimeUnit.SECONDS);
    }

    @Monitor(name="averageLoadPenalty", type=DataSourceType.GAUGE)
    double averageLoadPenalty() {
        return this.memoStats.get().averageLoadPenalty();
    }

    @Monitor(name="evictionCount", type=DataSourceType.COUNTER)
    long evictionCount() {
        return this.memoStats.get().evictionCount();
    }

    @Monitor(name="hitCount", type=DataSourceType.COUNTER)
    long hitCount() {
        return this.memoStats.get().hitCount();
    }

    @Monitor(name="loadCount", type=DataSourceType.COUNTER)
    long loadCount() {
        return this.memoStats.get().loadCount();
    }

    @Monitor(name="loadExceptionCount", type=DataSourceType.COUNTER)
    long loadExceptionCount() {
        return this.memoStats.get().loadExceptionCount();
    }

    @Monitor(name="loadSuccessCount", type=DataSourceType.COUNTER)
    long loadSuccessCount() {
        return this.memoStats.get().loadSuccessCount();
    }

    @Monitor(name="missCount", type=DataSourceType.COUNTER)
    long missCount() {
        return this.memoStats.get().missCount();
    }

    @Monitor(name="requestCount", type=DataSourceType.COUNTER)
    long requestCount() {
        return this.memoStats.get().requestCount();
    }

    @Monitor(name="totalLoadTime", type=DataSourceType.COUNTER)
    long totalLoadTime() {
        return this.memoStats.get().totalLoadTime();
    }
}

