/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Gauge;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Pollers;
import com.netflix.servo.monitor.StepLong;
import com.netflix.servo.util.Clock;
import com.netflix.servo.util.ClockWithOffset;
import java.util.concurrent.atomic.AtomicLong;

public class MaxGauge
extends AbstractMonitor<Long>
implements Gauge<Long> {
    private final StepLong max;

    public MaxGauge(MonitorConfig config) {
        this(config, ClockWithOffset.INSTANCE);
    }

    MaxGauge(MonitorConfig config, Clock clock) {
        super(config.withAdditionalTag(DataSourceType.GAUGE));
        this.max = new StepLong(0L, clock);
    }

    private void updateMax(int idx, long v) {
        AtomicLong current = this.max.getCurrent(idx);
        long m = current.get();
        while (v > m && !current.compareAndSet(m, v)) {
            m = current.get();
        }
    }

    public void update(long v) {
        for (int i = 0; i < Pollers.NUM_POLLERS; ++i) {
            this.updateMax(i, v);
        }
    }

    @Override
    public Long getValue(int nth) {
        return this.max.poll(nth).getValue();
    }

    public long getCurrentValue(int nth) {
        return this.max.getCurrent(nth).get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof MaxGauge)) {
            return false;
        }
        MaxGauge m = (MaxGauge)obj;
        return this.config.equals(m.getConfig()) && this.getValue(0).equals(m.getValue(0));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.getValue(0)});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("max", (Object)this.max).toString();
    }
}

