/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.BasicGauge;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.util.Clock;
import com.netflix.servo.util.ClockWithOffset;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class DurationTimer
extends AbstractMonitor<Long>
implements CompositeMonitor<Long> {
    private final List<Monitor<?>> monitors;
    private final AtomicLong nextTaskId = new AtomicLong(0L);
    private final ConcurrentMap<Long, Long> tasks = new ConcurrentHashMap<Long, Long>();
    private final Clock clock;

    private static MonitorConfig subId(MonitorConfig config, String sub) {
        String newName = config.getName() + "." + sub;
        return MonitorConfig.builder(newName).withTags(config.getTags()).withPublishingPolicy(config.getPublishingPolicy()).build();
    }

    public DurationTimer(MonitorConfig config) {
        this(config, ClockWithOffset.INSTANCE);
    }

    public DurationTimer(MonitorConfig config, Clock clock) {
        super(config);
        this.clock = clock;
        BasicGauge<Long> duration = new BasicGauge<Long>(DurationTimer.subId(config, "duration"), new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return DurationTimer.this.getDurationMillis() / 1000L;
            }
        });
        BasicGauge<Long> activeTasks = new BasicGauge<Long>(DurationTimer.subId(config, "activeTasks"), new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return DurationTimer.this.tasks.size();
            }
        });
        this.monitors = ImmutableList.of(duration, activeTasks);
    }

    private long getDurationMillis() {
        long now = this.clock.now();
        long sum = 0L;
        Iterator i$ = this.tasks.values().iterator();
        while (i$.hasNext()) {
            long startTime = (Long)i$.next();
            sum += now - startTime;
        }
        return Math.max(sum, 0L);
    }

    @Override
    public Long getValue() {
        return this.getValue(0);
    }

    @Override
    public Long getValue(int pollerIndex) {
        return this.getDurationMillis() / 1000L;
    }

    @Override
    public List<Monitor<?>> getMonitors() {
        return this.monitors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DurationTimer that = (DurationTimer)o;
        return this.getConfig().equals(that.getConfig()) && this.nextTaskId.get() == that.nextTaskId.get() && this.tasks.equals(that.tasks);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getConfig(), this.tasks, this.nextTaskId.get()});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.getConfig()).add("tasks", this.tasks).add("monitors", this.monitors).add("nextTaskId", this.nextTaskId.get()).toString();
    }

    public Stopwatch start() {
        DurationStopwatch s = new DurationStopwatch();
        s.start();
        return s;
    }

    private class DurationStopwatch
    implements Stopwatch {
        private long id = -1L;

        private DurationStopwatch() {
        }

        @Override
        public void start() {
            this.id = DurationTimer.this.nextTaskId.getAndIncrement();
            DurationTimer.this.tasks.put(this.id, DurationTimer.this.clock.now());
        }

        @Override
        public void stop() {
            if (this.id >= 0L) {
                DurationTimer.this.tasks.remove(this.id);
                this.id = -1L;
            }
        }

        @Override
        public void reset() {
            if (this.id >= 0L) {
                DurationTimer.this.tasks.put(this.id, DurationTimer.this.clock.now());
            }
        }

        @Override
        public long getDuration(TimeUnit timeUnit) {
            long durationMs = 0L;
            if (this.id >= 0L) {
                long start = (Long)DurationTimer.this.tasks.get(this.id);
                durationMs = DurationTimer.this.clock.now() - start;
            }
            durationMs = Math.max(0L, durationMs);
            return timeUnit.convert(durationMs, TimeUnit.MILLISECONDS);
        }

        @Override
        public long getDuration() {
            return this.getDuration(TimeUnit.SECONDS);
        }
    }
}

