/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.MonitorConfig;
import java.util.concurrent.atomic.AtomicLong;

public final class BasicCounter
extends AbstractMonitor<Number>
implements Counter {
    private final AtomicLong count = new AtomicLong();

    public BasicCounter(MonitorConfig config) {
        super(config.withAdditionalTag(DataSourceType.COUNTER));
    }

    @Override
    public void increment() {
        this.count.incrementAndGet();
    }

    @Override
    public void increment(long amount) {
        this.count.getAndAdd(amount);
    }

    @Override
    public Number getValue(int pollerIdx) {
        return this.count.get();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BasicCounter)) {
            return false;
        }
        BasicCounter m = (BasicCounter)obj;
        return this.config.equals(m.getConfig()) && this.count.get() == m.count.get();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.count.get()});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("count", this.count.get()).toString();
    }
}

