/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Gauge;
import com.netflix.servo.monitor.MonitorConfig;
import java.lang.ref.WeakReference;

public class NumberGauge
extends AbstractMonitor<Number>
implements Gauge<Number> {
    private final WeakReference<Number> numberRef;

    public NumberGauge(MonitorConfig config, Number number) {
        super(config.withAdditionalTag(DataSourceType.GAUGE));
        Preconditions.checkNotNull((Object)number);
        this.numberRef = new WeakReference<Number>(number);
    }

    @Override
    public Number getValue(int pollerIdx) {
        Number n = (Number)this.numberRef.get();
        return n != null ? (Number)n : (Number)Double.NaN;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NumberGauge)) {
            return false;
        }
        NumberGauge that = (NumberGauge)o;
        return this.config.equals(that.config) && ((Number)this.getValue()).equals(that.getValue());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.numberRef.get(), this.config});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("number", this.numberRef.get()).add("config", (Object)this.config).toString();
    }

    protected Number getBackingNumber() {
        return (Number)this.numberRef.get();
    }
}

