/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Datapoint;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Pollers;
import com.netflix.servo.util.Clock;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;

class StepLong {
    private static final Counter REPOLLED_INTERVALS = StepLong.newCounter("servo.monitor.repolledIntervals");
    private static final Counter POLLED_INTERVALS = StepLong.newCounter("servo.monitor.polledIntervals");
    private static final Counter MISSED_INTERVALS = StepLong.newCounter("servo.monitor.missedIntervals");
    private static final int PREVIOUS = 0;
    private static final int CURRENT = 1;
    private final long init;
    private final Clock clock;
    private final AtomicLong[] data;
    private final AtomicLong[] lastPollTime;
    private final AtomicLong[] lastInitPos;

    private static Counter newCounter(String name) {
        Counter c = Monitors.newCounter(name);
        DefaultMonitorRegistry.getInstance().register(c);
        return c;
    }

    StepLong(long init, Clock clock) {
        int i;
        this.init = init;
        this.clock = clock;
        this.lastInitPos = new AtomicLong[Pollers.NUM_POLLERS];
        this.lastPollTime = new AtomicLong[Pollers.NUM_POLLERS];
        for (i = 0; i < Pollers.NUM_POLLERS; ++i) {
            this.lastInitPos[i] = new AtomicLong(0L);
            this.lastPollTime[i] = new AtomicLong(0L);
        }
        this.data = new AtomicLong[2 * Pollers.NUM_POLLERS];
        for (i = 0; i < this.data.length; ++i) {
            this.data[i] = new AtomicLong(init);
        }
    }

    void addAndGet(long amount) {
        for (int i = 0; i < Pollers.NUM_POLLERS; ++i) {
            this.getCurrent(i).addAndGet(amount);
        }
    }

    private void rollCount(int pollerIndex, long now) {
        long step = Pollers.POLLING_INTERVALS[pollerIndex];
        long stepTime = now / step;
        long lastInit = this.lastInitPos[pollerIndex].get();
        if (lastInit < stepTime && this.lastInitPos[pollerIndex].compareAndSet(lastInit, stepTime)) {
            int prev = 2 * pollerIndex + 0;
            int curr = 2 * pollerIndex + 1;
            this.data[prev].set(this.data[curr].getAndSet(this.init));
        }
    }

    AtomicLong getCurrent(int pollerIndex) {
        this.rollCount(pollerIndex, this.clock.now());
        return this.data[2 * pollerIndex + 1];
    }

    Datapoint poll(int pollerIndex) {
        long now = this.clock.now();
        long step = Pollers.POLLING_INTERVALS[pollerIndex];
        this.rollCount(pollerIndex, now);
        int prevPos = 2 * pollerIndex + 0;
        long value = this.data[prevPos].getAndSet(this.init);
        long last = this.lastPollTime[pollerIndex].getAndSet(now);
        long missed = (now - last) / step - 1L;
        if (last / step == now / step) {
            REPOLLED_INTERVALS.increment();
            return new Datapoint(now / step * step, value);
        }
        if (last > 0L && missed > 0L) {
            MISSED_INTERVALS.increment(missed);
            return Datapoint.UNKNOWN;
        }
        POLLED_INTERVALS.increment();
        return new Datapoint(now / step * step, value);
    }

    public String toString() {
        return "StepLong{init=" + this.init + ", data=" + Arrays.toString(this.data) + ", lastPollTime=" + Arrays.toString(this.lastPollTime) + ", lastInitPos=" + Arrays.toString(this.lastInitPos) + '}';
    }
}

