/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.Metric;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.publish.MetricObserver;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.util.Clock;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NormalizationTransform
implements MetricObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(NormalizationTransform.class);
    private static final String DEFAULT_DSTYPE = DataSourceType.RATE.name();
    private static final Counter heartbeatExpireCount = NormalizationTransform.newCounter("servo.monitor.norm.heartbeatExpireCount");
    private final MetricObserver observer;
    private final long heartbeat;
    private final long step;
    private final Map<MonitorConfig, NormalizedValue> cache;
    private static long NO_PREVIOUS_UPDATE = -1L;

    static Counter newCounter(String name) {
        Counter c = Monitors.newCounter(name);
        DefaultMonitorRegistry.getInstance().register(c);
        return c;
    }

    public NormalizationTransform(MetricObserver observer, long step, long heartbeat) {
        this(observer, step, heartbeat, Clock.WALL);
    }

    public NormalizationTransform(MetricObserver observer, long step, final long heartbeat, final Clock clock) {
        Preconditions.checkNotNull((Object)observer);
        this.observer = observer;
        Preconditions.checkArgument((step > 0L ? 1 : 0) != 0, (Object)"step must be positive");
        this.step = step;
        Preconditions.checkArgument((heartbeat > 0L ? 1 : 0) != 0, (Object)"heartbeat must be positive");
        this.heartbeat = heartbeat;
        this.cache = new LinkedHashMap<MonitorConfig, NormalizedValue>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<MonitorConfig, NormalizedValue> eldest) {
                long lastMod;
                boolean expired;
                long now = clock.now();
                boolean bl = expired = now - (lastMod = eldest.getValue().lastUpdateTime) > heartbeat;
                if (expired) {
                    LOGGER.debug("heartbeat interval exceeded, expiring {}", (Object)eldest.getKey());
                }
                return expired;
            }
        };
    }

    private static String getDataSourceType(Metric m) {
        TagList tags = m.getConfig().getTags();
        String value = tags.getValue("type");
        if (value != null) {
            return value;
        }
        return DEFAULT_DSTYPE;
    }

    private static boolean isGauge(String dsType) {
        return dsType.equals(DataSourceType.GAUGE.name());
    }

    private static boolean isRate(String dsType) {
        return dsType.equals(DataSourceType.RATE.name());
    }

    private MonitorConfig toGaugeConfig(MonitorConfig config) {
        return config.withAdditionalTag(DataSourceType.GAUGE);
    }

    private Metric normalize(Metric m) {
        long offset = m.getTimestamp() % this.step;
        long stepBoundary = m.getTimestamp() - offset;
        NormalizedValue normalizedValue = this.cache.get(m.getConfig());
        if (normalizedValue == null) {
            normalizedValue = new NormalizedValue();
            this.cache.put(m.getConfig(), normalizedValue);
        }
        double value = normalizedValue.updateAndGet(m.getTimestamp(), m.getNumberValue().doubleValue());
        return new Metric(this.toGaugeConfig(m.getConfig()), stepBoundary, value);
    }

    @Override
    public void update(List<Metric> metrics) {
        Preconditions.checkNotNull(metrics);
        ArrayList newMetrics = Lists.newArrayListWithCapacity((int)metrics.size());
        for (Metric m : metrics) {
            String dsType = NormalizationTransform.getDataSourceType(m);
            if (NormalizationTransform.isGauge(dsType)) {
                newMetrics.add(m);
                continue;
            }
            if (NormalizationTransform.isRate(dsType)) {
                Metric normalized = this.normalize(m);
                if (normalized == null) continue;
                newMetrics.add(normalized);
                continue;
            }
            LOGGER.warn("NormalizationTransform should get only GAUGE and RATE metrics. Please use CounterToRateMetricTransform.");
        }
        this.observer.update(newMetrics);
    }

    @Override
    public String getName() {
        return this.observer.getName();
    }

    private class NormalizedValue {
        long lastUpdateTime = NormalizationTransform.access$200();
        double lastValue = 0.0;

        private NormalizedValue() {
        }

        private double weightedValue(long offset, double value) {
            double weight = (double)offset / (double)NormalizationTransform.this.step;
            return value * weight;
        }

        double updateAndGet(long timestamp, double value) {
            double result = Double.NaN;
            if (timestamp > this.lastUpdateTime) {
                long offset;
                long stepBoundary;
                if (this.lastUpdateTime > 0L && timestamp - this.lastUpdateTime > NormalizationTransform.this.heartbeat) {
                    heartbeatExpireCount.increment();
                    this.lastUpdateTime = NO_PREVIOUS_UPDATE;
                    this.lastValue = 0.0;
                }
                if (this.lastUpdateTime < (stepBoundary = timestamp - (offset = timestamp % NormalizationTransform.this.step))) {
                    if (this.lastUpdateTime != NO_PREVIOUS_UPDATE) {
                        long intervalOffset = this.lastUpdateTime % NormalizationTransform.this.step;
                        this.lastValue += this.weightedValue(NormalizationTransform.this.step - intervalOffset, value);
                        result = this.lastValue;
                    } else {
                        result = offset == 0L ? value : this.weightedValue(NormalizationTransform.this.step - offset, value);
                    }
                    this.lastValue = this.weightedValue(offset, value);
                } else {
                    long intervalOffset = timestamp - this.lastUpdateTime;
                    this.lastValue += this.weightedValue(intervalOffset, value);
                    result = this.lastValue;
                }
            }
            this.lastUpdateTime = timestamp;
            return result;
        }
    }
}

