/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Preconditions;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.Clock;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Datapoint;
import com.netflix.servo.monitor.MonitorConfig;
import java.util.concurrent.atomic.AtomicLong;

class StepLong {
    private static final Counter REPOLLED_INTERVALS = StepLong.newCounter("servo.monitor.repolledIntervals");
    private static final Counter POLLED_INTERVALS = StepLong.newCounter("servo.monitor.polledIntervals");
    private static final Counter MISSED_INTERVALS = StepLong.newCounter("servo.monitor.missedIntervals");
    private final long step;
    private final long init;
    private final Clock clock;
    private final AtomicLong[] data;
    private final AtomicLong lastPollTime = new AtomicLong(0L);
    private final AtomicLong lastInitPos = new AtomicLong(0L);

    private static Counter newCounter(String name) {
        BasicCounter c = new BasicCounter(MonitorConfig.builder(name).build());
        DefaultMonitorRegistry.getInstance().register(c);
        return c;
    }

    StepLong(long step, long init, Clock clock) {
        Preconditions.checkArgument((step >= 1000L ? 1 : 0) != 0, (Object)"minimum step size is 1 second");
        this.step = step;
        this.init = init;
        this.clock = clock;
        this.data = new AtomicLong[]{new AtomicLong(init), new AtomicLong(init)};
    }

    AtomicLong current() {
        long now = this.clock.now();
        long stepTime = now / this.step;
        int pos = (int)(stepTime % 2L);
        long v = this.data[pos].get();
        long lastInit = this.lastInitPos.get();
        if (lastInit != stepTime && this.lastInitPos.compareAndSet(lastInit, stepTime)) {
            this.data[pos].compareAndSet(v, this.init);
        }
        return this.data[pos];
    }

    Datapoint poll() {
        long now = this.clock.now();
        long stepTime = now / this.step;
        long value = this.data[(int)((stepTime + 1L) % 2L)].getAndSet(this.init);
        long last = this.lastPollTime.getAndSet(now);
        long missed = (now - last) / this.step - 1L;
        if (last / this.step == now / this.step) {
            REPOLLED_INTERVALS.increment();
            return new Datapoint(now / this.step * this.step, value);
        }
        if (last > 0L && missed > 0L) {
            MISSED_INTERVALS.increment(missed);
            return Datapoint.UNKNOWN;
        }
        POLLED_INTERVALS.increment();
        return new Datapoint(now / this.step * this.step, value);
    }
}

