/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.Gauge;
import com.netflix.servo.monitor.MonitorConfig;

public class NumberGauge
implements Gauge<Number> {
    private final Number number;
    private final MonitorConfig config;

    public NumberGauge(MonitorConfig config, Number number) {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)number);
        this.config = config.withAdditionalTag(DataSourceType.GAUGE);
        this.number = number;
    }

    @Override
    public Number getValue() {
        return this.number;
    }

    @Override
    public MonitorConfig getConfig() {
        return this.config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NumberGauge)) {
            return false;
        }
        NumberGauge that = (NumberGauge)o;
        return this.config.equals(that.config) && this.number.equals(that.number);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.number, this.config});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("number", (Object)this.number).add("config", (Object)this.config).toString();
    }
}

