/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.MaxGauge;
import com.netflix.servo.monitor.MinGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.ResettableCounter;
import com.netflix.servo.monitor.ResettableMonitor;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.TimedStopwatch;
import com.netflix.servo.monitor.Timer;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.Tags;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class BasicTimer
extends AbstractMonitor<Long>
implements Timer,
CompositeMonitor<Long> {
    private static final String STATISTIC = "statistic";
    private static final String UNIT = "unit";
    private static final Tag STAT_TOTAL = Tags.newTag("statistic", "totalTime");
    private static final Tag STAT_COUNT = Tags.newTag("statistic", "count");
    private static final Tag STAT_MIN = Tags.newTag("statistic", "min");
    private static final Tag STAT_MAX = Tags.newTag("statistic", "max");
    private final TimeUnit timeUnit;
    private final double timeUnitNanosFactor;
    private final ResettableCounter totalTime;
    private final ResettableCounter count;
    private final MinGauge min;
    private final MaxGauge max;
    private final List<Monitor<?>> monitors;

    public BasicTimer(MonitorConfig config) {
        this(config, TimeUnit.MILLISECONDS);
    }

    public BasicTimer(MonitorConfig config, TimeUnit unit) {
        super(config);
        Tag unitTag = Tags.newTag(UNIT, unit.name());
        MonitorConfig unitConfig = config.withAdditionalTag(unitTag);
        this.timeUnit = unit;
        this.timeUnitNanosFactor = 1.0 / (double)this.timeUnit.toNanos(1L);
        this.totalTime = new ResettableCounter(unitConfig.withAdditionalTag(STAT_TOTAL));
        this.count = new ResettableCounter(unitConfig.withAdditionalTag(STAT_COUNT));
        this.min = new MinGauge(unitConfig.withAdditionalTag(STAT_MIN));
        this.max = new MaxGauge(unitConfig.withAdditionalTag(STAT_MAX));
        ResettableFactorMonitor totalTimeFactor = new ResettableFactorMonitor(this.totalTime, this.timeUnitNanosFactor);
        ResettableFactorMonitor minFactor = new ResettableFactorMonitor(this.min, this.timeUnitNanosFactor);
        ResettableFactorMonitor maxFactor = new ResettableFactorMonitor(this.max, this.timeUnitNanosFactor);
        this.monitors = ImmutableList.of(totalTimeFactor, (Object)this.count, minFactor, maxFactor);
    }

    @Override
    public List<Monitor<?>> getMonitors() {
        return this.monitors;
    }

    @Override
    public Stopwatch start() {
        TimedStopwatch s = new TimedStopwatch(this);
        s.start();
        return s;
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    private void recordNanos(long nanos) {
        if (nanos > 0L) {
            this.totalTime.increment(nanos);
            this.count.increment();
            this.min.update(nanos);
            this.max.update(nanos);
        }
    }

    @Override
    @Deprecated
    public void record(long duration) {
        long nanos = this.timeUnit.toNanos(duration);
        this.recordNanos(nanos);
    }

    @Override
    public void record(long duration, TimeUnit unit) {
        this.recordNanos(unit.toNanos(duration));
    }

    private double getTotal() {
        return (double)this.totalTime.getCount() * this.timeUnitNanosFactor;
    }

    @Override
    public Long getValue() {
        long cnt = this.count.getCount();
        long value = (long)(this.getTotal() / (double)cnt);
        return cnt == 0L ? 0L : value;
    }

    public Double getTotalTime() {
        return this.getTotal();
    }

    public Long getCount() {
        return this.count.getCount();
    }

    public Double getMin() {
        return (double)this.min.getValue().longValue() * this.timeUnitNanosFactor;
    }

    public Double getMax() {
        return (double)this.max.getValue().longValue() * this.timeUnitNanosFactor;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BasicTimer)) {
            return false;
        }
        BasicTimer m = (BasicTimer)obj;
        return this.config.equals(m.getConfig()) && this.totalTime.equals(m.totalTime) && this.count.equals(m.count) && this.min.equals(m.min) && this.max.equals(m.max);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.totalTime, this.count, this.min, this.max});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("totalTime", (Object)this.totalTime).add("count", (Object)this.count).add("min", (Object)this.min).add("max", (Object)this.max).toString();
    }

    private static class ResettableFactorMonitor<T extends Number>
    implements ResettableMonitor<Double> {
        private final ResettableMonitor<T> wrapped;
        private final double factor;

        private ResettableFactorMonitor(ResettableMonitor<T> wrapped, double factor) {
            this.wrapped = wrapped;
            this.factor = factor;
        }

        @Override
        public Double getValue() {
            return ((Number)this.wrapped.getValue()).doubleValue() * this.factor;
        }

        @Override
        public MonitorConfig getConfig() {
            return this.wrapped.getConfig();
        }

        @Override
        public Double getAndResetValue() {
            return this.getAndResetValue(0);
        }

        @Override
        public Double getAndResetValue(int pollerIdx) {
            return ((Number)this.wrapped.getAndResetValue(pollerIdx)).doubleValue() * this.factor;
        }
    }
}

