/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.Gauge;
import com.netflix.servo.monitor.MonitorConfig;
import java.util.concurrent.atomic.AtomicLong;

public class LongGauge
implements Gauge<Long> {
    private final AtomicLong number = new AtomicLong(0L);
    private final MonitorConfig config;

    public LongGauge(MonitorConfig config) {
        this.config = config.withAdditionalTag(DataSourceType.GAUGE);
    }

    public void set(Long n) {
        this.number.set(n);
    }

    @Override
    public Long getValue() {
        return this.number.get();
    }

    @Override
    public MonitorConfig getConfig() {
        return this.config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongGauge)) {
            return false;
        }
        LongGauge that = (LongGauge)o;
        return this.config.equals(that.config) && this.number.equals(that.number);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.number, this.config});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("number", (Object)this.number).add("config", (Object)this.config).toString();
    }
}

