/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.AtomicUtils;
import com.netflix.servo.monitor.Gauge;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Pollers;
import com.netflix.servo.monitor.ResettableMonitor;
import java.util.concurrent.atomic.AtomicLongArray;

public class MaxGauge
extends AbstractMonitor<Long>
implements Gauge<Long>,
ResettableMonitor<Long> {
    private final AtomicLongArray max = new AtomicLongArray(Pollers.NUM_POLLERS);

    public MaxGauge(MonitorConfig config) {
        super(config.withAdditionalTag(DataSourceType.GAUGE));
    }

    private void updateMax(int idx, long v) {
        long currentMaxValue = this.max.get(idx);
        while (v > currentMaxValue && !this.max.compareAndSet(idx, currentMaxValue, v)) {
            currentMaxValue = this.max.get(idx);
        }
    }

    public void update(long v) {
        for (int i = 0; i < this.max.length(); ++i) {
            this.updateMax(i, v);
        }
    }

    @Override
    public Long getValue() {
        return this.max.get(0);
    }

    @Override
    public Long getAndResetValue() {
        return this.getAndResetValue(0);
    }

    @Override
    public Long getAndResetValue(int idx) {
        return this.max.getAndSet(idx, 0L);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MaxGauge)) {
            return false;
        }
        MaxGauge m = (MaxGauge)obj;
        return this.config.equals(m.getConfig()) && AtomicUtils.equals(this.max, m.max);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, AtomicUtils.hashCode(this.max)});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("max", (Object)this.max).toString();
    }
}

