/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.collect.Lists;
import com.netflix.servo.Metric;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.publish.MetricFilter;
import com.netflix.servo.publish.MetricPoller;
import com.netflix.servo.tag.BasicTag;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.TagList;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmMetricPoller
implements MetricPoller {
    private static final String CLASS = "class";
    private static final MonitorConfig LOADED_CLASS_COUNT = MonitorConfig.builder("loadedClassCount").withTag("class", ClassLoadingMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig TOTAL_LOADED_CLASS_COUNT = MonitorConfig.builder("totalLoadedClassCount").withTag("class", ClassLoadingMXBean.class.getSimpleName()).withTag(DataSourceType.COUNTER).build();
    private static final MonitorConfig UNLOADED_CLASS_COUNT = MonitorConfig.builder("unloadedClassCount").withTag("class", ClassLoadingMXBean.class.getSimpleName()).withTag(DataSourceType.COUNTER).build();
    private static final MonitorConfig TOTAL_COMPILATION_TIME = MonitorConfig.builder("totalCompilationTime").withTag("class", CompilationMXBean.class.getSimpleName()).withTag(DataSourceType.COUNTER).build();
    private static final MonitorConfig COLLECTION_COUNT = MonitorConfig.builder("collectionCount").withTag("class", GarbageCollectorMXBean.class.getSimpleName()).withTag(DataSourceType.COUNTER).build();
    private static final MonitorConfig COLLECTION_TIME = MonitorConfig.builder("collectionTime").withTag("class", GarbageCollectorMXBean.class.getSimpleName()).withTag(DataSourceType.COUNTER).build();
    private static final MonitorConfig COMMITTED_USAGE = MonitorConfig.builder("committedUsage").withTag("class", MemoryPoolMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig INIT_USAGE = MonitorConfig.builder("initUsage").withTag("class", MemoryPoolMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig MAX_USAGE = MonitorConfig.builder("maxUsage").withTag("class", MemoryPoolMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig ACTUAL_USAGE = MonitorConfig.builder("actualUsage").withTag("class", MemoryPoolMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig AVAILABLE_PROCESSORS = MonitorConfig.builder("availableProcessors").withTag("class", OperatingSystemMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig LOAD_AVERAGE = MonitorConfig.builder("systemLoadAverage").withTag("class", OperatingSystemMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig MAX_FILE_DESCRIPTOR_COUNT = MonitorConfig.builder("maxFileDescriptorCount").withTag("class", OperatingSystemMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig OPEN_FILE_DESCRIPTOR_COUNT = MonitorConfig.builder("openFileDescriptorCount").withTag("class", OperatingSystemMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig COMMITTED_VIRTUAL_MEMORY_SIZE = MonitorConfig.builder("committedVirtualMemorySize").withTag("class", OperatingSystemMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig TOTAL_PHYSICAL_MEMORY_SIZE = MonitorConfig.builder("totalPhysicalMemorySize").withTag("class", OperatingSystemMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig FREE_PHYSICAL_MEMORY_SIZE = MonitorConfig.builder("freePhysicalMemorySize").withTag("class", OperatingSystemMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig TOTAL_SWAP_SPACE_SIZE = MonitorConfig.builder("totalSwapSpaceSize").withTag("class", OperatingSystemMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig FREE_SWAP_SPACE_SIZE = MonitorConfig.builder("freeSwapSpaceSize").withTag("class", OperatingSystemMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig PROCESS_CPU_LOAD = MonitorConfig.builder("processCpuLoad").withTag("class", OperatingSystemMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig SYSTEM_CPU_LOAD = MonitorConfig.builder("systemCpuLoad").withTag("class", OperatingSystemMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig DAEMON_THREAD_COUNT = MonitorConfig.builder("daemonThreadCount").withTag("class", ThreadMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig THREAD_COUNT = MonitorConfig.builder("threadCount").withTag("class", ThreadMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig TOTAL_STARTED_THREAD_COUNT = MonitorConfig.builder("totalStartedThreadCount").withTag("class", ThreadMXBean.class.getSimpleName()).withTag(DataSourceType.COUNTER).build();
    private static final Logger LOGGER = LoggerFactory.getLogger(JvmMetricPoller.class);

    @Override
    public final List<Metric> poll(MetricFilter filter) {
        return this.poll(filter, false);
    }

    @Override
    public final List<Metric> poll(MetricFilter filter, boolean reset) {
        long now = System.currentTimeMillis();
        MetricList metrics = new MetricList(filter);
        this.addClassLoadingMetrics(now, metrics);
        this.addCompilationMetrics(now, metrics);
        this.addGarbageCollectorMetrics(now, metrics);
        this.addMemoryPoolMetrics(now, metrics);
        this.addOperatingSystemMetrics(now, metrics);
        this.addThreadMetrics(now, metrics);
        return metrics.getList();
    }

    private void addClassLoadingMetrics(long timestamp, MetricList metrics) {
        ClassLoadingMXBean bean = ManagementFactory.getClassLoadingMXBean();
        metrics.add(new Metric(LOADED_CLASS_COUNT, timestamp, bean.getLoadedClassCount()));
        metrics.add(new Metric(TOTAL_LOADED_CLASS_COUNT, timestamp, bean.getTotalLoadedClassCount()));
        metrics.add(new Metric(UNLOADED_CLASS_COUNT, timestamp, bean.getUnloadedClassCount()));
    }

    private void addCompilationMetrics(long timestamp, MetricList metrics) {
        CompilationMXBean bean = ManagementFactory.getCompilationMXBean();
        metrics.add(new Metric(TOTAL_COMPILATION_TIME, timestamp, bean.getTotalCompilationTime()));
    }

    private void addGarbageCollectorMetrics(long timestamp, MetricList metrics) {
        List<GarbageCollectorMXBean> beans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean bean : beans) {
            BasicTag id = new BasicTag("id", bean.getName());
            metrics.add(new Metric(COLLECTION_COUNT.withAdditionalTag(id), timestamp, bean.getCollectionCount()));
            metrics.add(new Metric(COLLECTION_TIME.withAdditionalTag(id), timestamp, bean.getCollectionTime()));
        }
    }

    private void addMemoryPoolMetrics(long timestamp, MetricList metrics) {
        List<MemoryPoolMXBean> beans = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean bean : beans) {
            BasicTagList tags = BasicTagList.of("id", bean.getName(), "memtype", bean.getType().name());
            this.addMemoryUsageMetrics(tags, timestamp, bean.getUsage(), metrics);
        }
    }

    private void addMemoryUsageMetrics(TagList tags, long timestamp, MemoryUsage usage, MetricList metrics) {
        metrics.add(new Metric(COMMITTED_USAGE.withAdditionalTags(tags), timestamp, usage.getCommitted()));
        metrics.add(new Metric(INIT_USAGE.withAdditionalTags(tags), timestamp, usage.getInit()));
        metrics.add(new Metric(ACTUAL_USAGE.withAdditionalTags(tags), timestamp, usage.getUsed()));
        metrics.add(new Metric(MAX_USAGE.withAdditionalTags(tags), timestamp, usage.getMax()));
    }

    private void addOperatingSystemMetrics(long timestamp, MetricList metrics) {
        OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
        metrics.add(new Metric(AVAILABLE_PROCESSORS, timestamp, bean.getAvailableProcessors()));
        metrics.add(new Metric(LOAD_AVERAGE, timestamp, bean.getSystemLoadAverage()));
        this.addOptionalMetric(MAX_FILE_DESCRIPTOR_COUNT, timestamp, bean, "getMaxFileDescriptorCount", metrics);
        this.addOptionalMetric(OPEN_FILE_DESCRIPTOR_COUNT, timestamp, bean, "getOpenFileDescriptorCount", metrics);
        this.addOptionalMetric(COMMITTED_VIRTUAL_MEMORY_SIZE, timestamp, bean, "getCommittedVirtualMemorySize", metrics);
        this.addOptionalMetric(TOTAL_PHYSICAL_MEMORY_SIZE, timestamp, bean, "getTotalPhysicalMemorySize", metrics);
        this.addOptionalMetric(FREE_PHYSICAL_MEMORY_SIZE, timestamp, bean, "getFreePhysicalMemorySize", metrics);
        this.addOptionalMetric(TOTAL_SWAP_SPACE_SIZE, timestamp, bean, "getTotalSwapSpaceSize", metrics);
        this.addOptionalMetric(FREE_SWAP_SPACE_SIZE, timestamp, bean, "getFreeSwapSpaceSize", metrics);
        this.addOptionalMetric(PROCESS_CPU_LOAD, timestamp, bean, "getProcessCpuLoad", metrics);
        this.addOptionalMetric(SYSTEM_CPU_LOAD, timestamp, bean, "getSystemCpuLoad", metrics);
    }

    private void addThreadMetrics(long timestamp, MetricList metrics) {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        metrics.add(new Metric(DAEMON_THREAD_COUNT, timestamp, bean.getDaemonThreadCount()));
        metrics.add(new Metric(THREAD_COUNT, timestamp, bean.getThreadCount()));
        metrics.add(new Metric(TOTAL_STARTED_THREAD_COUNT, timestamp, bean.getTotalStartedThreadCount()));
    }

    private void addOptionalMetric(MonitorConfig config, long timestamp, Object obj, String methodName, MetricList metrics) {
        try {
            Method method = obj.getClass().getMethod(methodName, new Class[0]);
            method.setAccessible(true);
            Number value = (Number)method.invoke(obj, new Object[0]);
            metrics.add(new Metric(config, timestamp, value));
        }
        catch (Exception e) {
            String msg = String.format("failed to get value for %s.%s", obj.getClass().getName(), methodName);
            LOGGER.debug(msg, (Throwable)e);
        }
    }

    private static class MetricList {
        private final MetricFilter filter;
        private final List<Metric> list;

        public MetricList(MetricFilter filter) {
            this.filter = filter;
            this.list = Lists.newArrayList();
        }

        public void add(Metric m) {
            if (this.filter.matches(m.getConfig())) {
                this.list.add(m);
            }
        }

        public List<Metric> getList() {
            return this.list;
        }
    }
}

