/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.collect.ImmutableList;
import com.netflix.servo.Metric;
import com.netflix.servo.publish.BaseMetricObserver;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MemoryMetricObserver
extends BaseMetricObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryMetricObserver.class);
    private static final int DEFAULT_N = 10;
    private final List<Metric>[] observations;
    private int next;

    public MemoryMetricObserver() {
        this("unamed observer", 10);
    }

    public MemoryMetricObserver(String name, int num) {
        super(name);
        this.observations = new List[num];
        this.next = 0;
    }

    @Override
    public void updateImpl(List<Metric> metrics) {
        this.observations[this.next] = metrics;
        this.next = (this.next + 1) % this.observations.length;
    }

    public List<List<Metric>> getObservations() {
        ImmutableList.Builder builder = ImmutableList.builder();
        int pos = this.next;
        for (int i = 0; i < this.observations.length; ++i) {
            if (this.observations[pos] != null) {
                builder.add(this.observations[pos]);
            }
            pos = (pos + 1) % this.observations.length;
        }
        return builder.build();
    }
}

