/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.netflix.servo.Metric;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.annotations.MonitorTags;
import com.netflix.servo.publish.MetricObserver;
import com.netflix.servo.tag.SortedTagList;
import com.netflix.servo.tag.StandardTagKeys;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.tag.Tags;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BaseMetricObserver
implements MetricObserver {
    @MonitorTags
    private final TagList tags;
    private final String name;
    @Monitor(name="updateCount", type=DataSourceType.COUNTER)
    private final AtomicInteger updateCount = new AtomicInteger(0);
    @Monitor(name="updateFailureCount", type=DataSourceType.COUNTER)
    private final AtomicInteger failedUpdateCount = new AtomicInteger(0);

    public BaseMetricObserver(String name) {
        Tag id = Tags.newTag(StandardTagKeys.MONITOR_ID.getKeyName(), name);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.tags = SortedTagList.builder().withTag(id).build();
    }

    public abstract void updateImpl(List<Metric> var1);

    @Override
    public final void update(List<Metric> metrics) {
        Preconditions.checkNotNull(metrics);
        try {
            this.updateImpl(metrics);
        }
        catch (Throwable t) {
            this.failedUpdateCount.incrementAndGet();
            throw Throwables.propagate((Throwable)t);
        }
        finally {
            this.updateCount.incrementAndGet();
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    protected final void incrementFailedCount() {
        this.failedUpdateCount.incrementAndGet();
    }

    public int getUpdateCount() {
        return this.updateCount.get();
    }

    public int getFailedUpdateCount() {
        return this.failedUpdateCount.get();
    }
}

