/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.monitor.BasicTimer;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import com.netflix.servo.tag.TagList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicTimer
implements CompositeMonitor<Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicTimer.class);
    private static final String DEFAULT_EXPIRATION = "15";
    private static final String DEFAULT_EXPIRATION_UNIT = "MINUTES";
    private static final String CLASS_NAME = DynamicTimer.class.getCanonicalName();
    private static final String EXPIRATION_PROP = CLASS_NAME + ".expiration";
    private static final String EXPIRATION_PROP_UNIT = CLASS_NAME + ".expirationUnit";
    private static final String INTERNAL_ID = "servoTimers";
    private static final String CACHE_MONITOR_ID = "servoTimersCache";
    private static final MonitorConfig baseConfig = new MonitorConfig.Builder("servoTimers").build();
    private static final DynamicTimer INSTANCE = new DynamicTimer();
    private final LoadingCache<ConfigUnit, Timer> timers;
    private final CompositeMonitor<?> cacheMonitor;

    private DynamicTimer() {
        String expiration = System.getProperty(EXPIRATION_PROP, DEFAULT_EXPIRATION);
        String expirationUnit = System.getProperty(EXPIRATION_PROP_UNIT, DEFAULT_EXPIRATION_UNIT);
        long expirationValue = Long.valueOf(expiration);
        TimeUnit expirationUnitValue = TimeUnit.valueOf(expirationUnit);
        this.timers = CacheBuilder.newBuilder().expireAfterAccess(expirationValue, expirationUnitValue).build((CacheLoader)new CacheLoader<ConfigUnit, Timer>(){

            public Timer load(ConfigUnit configUnit) throws Exception {
                return new BasicTimer(configUnit.config, configUnit.unit);
            }
        });
        this.cacheMonitor = Monitors.newCacheMonitor(CACHE_MONITOR_ID, this.timers);
        DefaultMonitorRegistry.getInstance().register(this);
    }

    private Timer get(MonitorConfig config, TimeUnit unit) {
        try {
            return (Timer)this.timers.get((Object)new ConfigUnit(config, unit));
        }
        catch (ExecutionException e) {
            LOGGER.error("Failed to get a timer for {}: {}", (Object)config, (Object)e.getMessage());
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Stopwatch start(MonitorConfig config, TimeUnit unit) {
        return INSTANCE.get(config, unit).start();
    }

    public static Stopwatch start(MonitorConfig config) {
        return INSTANCE.get(config, TimeUnit.MILLISECONDS).start();
    }

    public static Stopwatch start(String name, String ... tags) {
        MonitorConfig.Builder configBuilder = MonitorConfig.builder(name);
        Preconditions.checkArgument((tags.length % 2 == 0 ? 1 : 0) != 0, (Object)"The sequence of (key, value) pairs must have even size: one key, one value");
        for (int i = 0; i < tags.length; i += 2) {
            configBuilder.withTag(tags[i], tags[i + 1]);
        }
        return INSTANCE.get(configBuilder.build(), TimeUnit.MILLISECONDS).start();
    }

    public static Stopwatch start(String name, TagList list) {
        MonitorConfig config = new MonitorConfig.Builder(name).withTags(list).build();
        return INSTANCE.get(config, TimeUnit.MILLISECONDS).start();
    }

    public static Stopwatch start(String name, TagList list, TimeUnit unit) {
        MonitorConfig config = new MonitorConfig.Builder(name).withTags(list).build();
        return INSTANCE.get(config, unit).start();
    }

    @Override
    public List<Monitor<?>> getMonitors() {
        ConcurrentMap timersMap = this.timers.asMap();
        return ImmutableList.copyOf(timersMap.values());
    }

    @Override
    public Long getValue() {
        return this.timers.asMap().size();
    }

    @Override
    public MonitorConfig getConfig() {
        return baseConfig;
    }

    public String toString() {
        ConcurrentMap map = this.timers.asMap();
        return Objects.toStringHelper((Object)this).add("baseConfig", (Object)baseConfig).add("totalTimers", map.size()).add("timers", (Object)map).toString();
    }

    static class ConfigUnit {
        final MonitorConfig config;
        final TimeUnit unit;

        ConfigUnit(MonitorConfig config, TimeUnit unit) {
            this.config = config;
            this.unit = unit;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigUnit that = (ConfigUnit)o;
            return this.config.equals(that.config) && this.unit == that.unit;
        }

        public int hashCode() {
            int result = this.config.hashCode();
            result = 31 * result + this.unit.hashCode();
            return result;
        }
    }
}

