/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Gauge;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.ResettableMonitor;
import java.util.concurrent.atomic.AtomicLong;

public class MinGauge
extends AbstractMonitor<Long>
implements Gauge<Long>,
ResettableMonitor<Long> {
    private AtomicLong min = new AtomicLong(Long.MAX_VALUE);

    public MinGauge(MonitorConfig config) {
        super(config.withAdditionalTag(DataSourceType.GAUGE));
    }

    public void update(long v) {
        if (v < this.min.get()) {
            this.min.set(v);
        }
    }

    @Override
    public Long getValue() {
        long v = this.min.get();
        return v == Long.MAX_VALUE ? 0L : v;
    }

    @Override
    public Long getAndResetValue() {
        long v = this.min.getAndSet(Long.MAX_VALUE);
        return v == Long.MAX_VALUE ? 0L : v;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MinGauge)) {
            return false;
        }
        MinGauge m = (MinGauge)obj;
        return this.config.equals(m.getConfig()) && this.min.get() == m.min.get();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.min.get()});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("min", this.min.get()).toString();
    }
}

