/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadCpuStats {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadCpuStats.class);
    private static final ThreadCpuStats INSTANCE = new ThreadCpuStats();
    private static final long ONE_MINUTE_NANOS = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MINUTES);
    private static final long FIVE_MINUTE_NANOS = 5L * ONE_MINUTE_NANOS;
    private static final long FIFTEEN_MINUTE_NANOS = 15L * ONE_MINUTE_NANOS;
    private volatile boolean running = false;
    private final CpuUsage jvmCpuUsage = new CpuUsage(-1L, "jvm");
    private final Map<Long, CpuUsage> threadCpuUsages = new ConcurrentHashMap<Long, CpuUsage>();

    public static ThreadCpuStats getInstance() {
        return INSTANCE;
    }

    private ThreadCpuStats() {
    }

    public boolean isRunning() {
        return false;
    }

    public synchronized void start() {
        if (!this.running) {
            this.running = true;
            Thread t = new Thread((Runnable)new CpuStatRunnable(), "ThreadCpuStatsCollector");
            t.start();
        }
    }

    public void stop() {
        this.running = false;
    }

    public CpuUsage getOverallCpuUsage() {
        return this.jvmCpuUsage;
    }

    public List<CpuUsage> getThreadCpuUsages() {
        return new ArrayList<CpuUsage>(this.threadCpuUsages.values());
    }

    public static double toPercent(long value, long total) {
        return total > 0L ? 100.0 * (double)value / (double)total : 0.0;
    }

    private static long append(StringBuilder buf, char label, long unit, long time) {
        if (time > unit) {
            long multiple = time / unit;
            buf.append(multiple).append(label);
            return time % unit;
        }
        return time;
    }

    public static String toDuration(long time) {
        long second = 1000000000L;
        long minute = 60000000000L;
        long hour = 3600000000000L;
        long day = 86400000000000L;
        long week = 604800000000000L;
        StringBuilder buf = new StringBuilder();
        buf.append('P');
        time = ThreadCpuStats.append(buf, 'W', 604800000000000L, time);
        time = ThreadCpuStats.append(buf, 'D', 86400000000000L, time);
        buf.append('T');
        time = ThreadCpuStats.append(buf, 'H', 604800000000000L, time);
        time = ThreadCpuStats.append(buf, 'M', 60000000000L, time);
        time = ThreadCpuStats.append(buf, 'S', 1000000000L, time);
        return buf.toString();
    }

    public void printThreadCpuUsages() {
        this.printThreadCpuUsages(System.out, CpuUsageComparator.ONE_MINUTE);
    }

    public void printThreadCpuUsages(OutputStream out, CpuUsageComparator cmp) {
        PrintWriter writer = new PrintWriter(out, true);
        CpuUsage overall = this.getOverallCpuUsage();
        List<CpuUsage> usages = this.getThreadCpuUsages();
        Collections.sort(usages, cmp);
        writer.printf("Time: %s%n%n", new Date());
        long uptimeMillis = ManagementFactory.getRuntimeMXBean().getUptime();
        long uptimeNanos = TimeUnit.NANOSECONDS.convert(uptimeMillis, TimeUnit.MILLISECONDS);
        writer.printf("Uptime: %s%n%n", ThreadCpuStats.toDuration(uptimeNanos));
        writer.println("JVM Usage Time: ");
        writer.printf("%11s %11s %11s %11s   %7s   %s%n", "1-min", "5-min", "15-min", "overall", "id", "name");
        writer.printf("%11s %11s %11s %11s   %7s   %s%n", ThreadCpuStats.toDuration(overall.getOneMinute()), ThreadCpuStats.toDuration(overall.getFiveMinute()), ThreadCpuStats.toDuration(overall.getFifteenMinute()), ThreadCpuStats.toDuration(overall.getOverall()), "-", "jvm");
        writer.println();
        int numProcs = Runtime.getRuntime().availableProcessors();
        writer.println("JVM Usage Percent: ");
        writer.printf("%11s %11s %11s %11s   %7s   %s%n", "1-min", "5-min", "15-min", "overall", "id", "name");
        writer.printf("%10.2f%% %10.2f%% %10.2f%% %10.2f%%   %7s   %s%n", ThreadCpuStats.toPercent(overall.getOneMinute(), ONE_MINUTE_NANOS * (long)numProcs), ThreadCpuStats.toPercent(overall.getFiveMinute(), FIVE_MINUTE_NANOS * (long)numProcs), ThreadCpuStats.toPercent(overall.getFifteenMinute(), FIFTEEN_MINUTE_NANOS * (long)numProcs), ThreadCpuStats.toPercent(overall.getOverall(), uptimeNanos * (long)numProcs), "-", "jvm");
        writer.println();
        writer.println("Breakdown by thread (100% = total cpu usage for jvm):");
        writer.printf("%11s %11s %11s %11s   %7s   %s%n", "1-min", "5-min", "15-min", "overall", "id", "name");
        for (CpuUsage usage : usages) {
            writer.printf("%10.2f%% %10.2f%% %10.2f%% %10.2f%%   %7d   %s%n", ThreadCpuStats.toPercent(usage.getOneMinute(), overall.getOneMinute()), ThreadCpuStats.toPercent(usage.getFiveMinute(), overall.getFiveMinute()), ThreadCpuStats.toPercent(usage.getFifteenMinute(), overall.getFifteenMinute()), ThreadCpuStats.toPercent(usage.getOverall(), overall.getOverall()), usage.getThreadId(), usage.getName());
        }
        writer.println();
        writer.flush();
    }

    private void updateStats() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        if (bean.isThreadCpuTimeEnabled()) {
            long[] ids = bean.getAllThreadIds();
            Arrays.sort(ids);
            long totalCpuTime = 0L;
            for (int i = 0; i < ids.length; ++i) {
                long cpuTime = bean.getThreadCpuTime(ids[i]);
                if (cpuTime == -1L) continue;
                totalCpuTime += cpuTime;
                CpuUsage usage = this.threadCpuUsages.get(ids[i]);
                if (usage == null) {
                    ThreadInfo info = bean.getThreadInfo(ids[i]);
                    usage = new CpuUsage(ids[i], info.getThreadName());
                    this.threadCpuUsages.put(ids[i], usage);
                }
                usage.update(cpuTime);
            }
            OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
            try {
                Method m = osBean.getClass().getMethod("getProcessCpuTime", new Class[0]);
                long jvmCpuTime = (Long)m.invoke((Object)osBean, new Object[0]);
                this.jvmCpuUsage.update(jvmCpuTime < 0L ? totalCpuTime : jvmCpuTime);
            }
            catch (Exception e) {
                this.jvmCpuUsage.update(totalCpuTime);
            }
            long ageLimit = 900000L;
            long now = System.currentTimeMillis();
            Iterator<Map.Entry<Long, CpuUsage>> iter = this.threadCpuUsages.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Long, CpuUsage> entry = iter.next();
                long id = entry.getKey();
                CpuUsage usage = entry.getValue();
                if (now - usage.getLastUpdateTime() > 900000L) {
                    iter.remove();
                    continue;
                }
                if (Arrays.binarySearch(ids, id) >= 0) continue;
                usage.updateNoValue();
            }
        } else {
            LOGGER.debug("ThreadMXBean.isThreadCpuTimeEnabled() == false, cannot collect stats");
        }
    }

    public static enum CpuUsageComparator implements Comparator<CpuUsage>
    {
        ONE_MINUTE(0),
        FIVE_MINUTE(1),
        FIFTEEN_MINUTE(2),
        OVERALL(3);

        private final int col;

        private CpuUsageComparator(int col) {
            this.col = col;
        }

        @Override
        public int compare(CpuUsage u1, CpuUsage u2) {
            long cmp = 0L;
            switch (this.col) {
                case 0: {
                    cmp = u2.getOneMinute() - u1.getOneMinute();
                    break;
                }
                case 1: {
                    cmp = u2.getFiveMinute() - u1.getFiveMinute();
                    break;
                }
                case 2: {
                    cmp = u2.getFifteenMinute() - u1.getFifteenMinute();
                    break;
                }
                default: {
                    cmp = u2.getOverall() - u1.getOverall();
                }
            }
            return cmp < 0L ? -1 : (cmp > 0L ? 1 : 0);
        }
    }

    public static class CpuUsage {
        private static final int BUFFER_SIZE = 16;
        private final long id;
        private final String name;
        private final AtomicLong lastUpdateTime = new AtomicLong(0L);
        private final AtomicInteger nextPos = new AtomicInteger(0);
        private AtomicLongArray totals = new AtomicLongArray(16);

        private CpuUsage(long id, String name) {
            this.id = id;
            this.name = name;
        }

        public long getThreadId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public long getLastUpdateTime() {
            return this.lastUpdateTime.get();
        }

        public long getOverall() {
            int currentPos = this.toIndex(this.nextPos.get() - 1);
            return this.totals.get(currentPos);
        }

        public long getOneMinute() {
            return this.get(1);
        }

        public long getFiveMinute() {
            return this.get(5);
        }

        public long getFifteenMinute() {
            return this.get(15);
        }

        private int toIndex(int v) {
            return (v < 0 ? v + 16 : v) % 16;
        }

        private long get(int n) {
            long startValue;
            int currentPos = this.toIndex(this.nextPos.get() - 1);
            int startPos = this.toIndex(currentPos - n);
            long currentValue = this.totals.get(currentPos);
            long diff = currentValue - (startValue = this.totals.get(startPos));
            return diff < 0L ? 0L : diff;
        }

        private void update(long threadTotal) {
            this.totals.set(this.toIndex(this.nextPos.getAndIncrement()), threadTotal);
            this.lastUpdateTime.set(System.currentTimeMillis());
        }

        private void updateNoValue() {
            int currentPos = this.toIndex(this.nextPos.get() - 1);
            this.update(this.totals.get(currentPos));
        }
    }

    private class CpuStatRunnable
    implements Runnable {
        private CpuStatRunnable() {
        }

        @Override
        public void run() {
            long step = 60000L;
            long maxUpdateTime = 10000L;
            while (ThreadCpuStats.this.running) {
                try {
                    long delay;
                    long start = System.currentTimeMillis();
                    ThreadCpuStats.this.updateStats();
                    long elapsed = System.currentTimeMillis() - start;
                    if (elapsed > 10000L) {
                        LOGGER.warn("update stats is slow, took {} milliseconds", (Object)elapsed);
                    }
                    Thread.sleep((delay = 60000L - elapsed) < 1000L ? 60000L : delay);
                }
                catch (Exception e) {
                    LOGGER.warn("failed to update thread stats", (Throwable)e);
                }
            }
        }
    }
}

