/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.netflix.servo.Metric;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.publish.MetricObserver;
import com.netflix.servo.tag.TagList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CounterToRateMetricTransform
implements MetricObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(CounterToRateMetricTransform.class);
    private static final String COUNTER_VALUE = DataSourceType.COUNTER.name();
    private final MetricObserver observer;
    private final Map<MonitorConfig, CounterValue> cache;

    public CounterToRateMetricTransform(MetricObserver observer, long heartbeat, TimeUnit unit) {
        this.observer = observer;
        final long heartbeatMillis = TimeUnit.MILLISECONDS.convert(heartbeat, unit);
        this.cache = new LinkedHashMap<MonitorConfig, CounterValue>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<MonitorConfig, CounterValue> eldest) {
                long lastMod;
                boolean expired;
                long now = System.currentTimeMillis();
                boolean bl = expired = now - (lastMod = eldest.getValue().getTimestamp()) > heartbeatMillis;
                if (expired) {
                    LOGGER.debug("heartbeat interval exceeded, expiring {}", (Object)eldest.getKey());
                }
                return expired;
            }
        };
    }

    @Override
    public String getName() {
        return this.observer.getName();
    }

    @Override
    public void update(List<Metric> metrics) {
        Preconditions.checkNotNull(metrics);
        LOGGER.debug("received {} metrics", (Object)metrics.size());
        ArrayList newMetrics = Lists.newArrayListWithCapacity((int)metrics.size());
        for (Metric m : metrics) {
            if (this.isCounter(m)) {
                CounterValue prev = this.cache.get(m.getConfig());
                if (prev != null) {
                    double rate = prev.computeRate(m);
                    newMetrics.add(new Metric(m.getConfig(), m.getTimestamp(), rate));
                    continue;
                }
                CounterValue current = new CounterValue(m);
                this.cache.put(m.getConfig(), current);
                continue;
            }
            newMetrics.add(m);
        }
        LOGGER.debug("writing {} metrics to downstream observer", (Object)newMetrics.size());
        this.observer.update(newMetrics);
    }

    public void reset() {
        this.cache.clear();
    }

    private boolean isCounter(Metric m) {
        TagList tags = m.getConfig().getTags();
        String value = tags.getValue("type");
        return value != null && COUNTER_VALUE.equals(value);
    }

    private static class CounterValue {
        private long timestamp;
        private double value;

        public CounterValue(long timestamp, double value) {
            this.timestamp = timestamp;
            this.value = value;
        }

        public CounterValue(Metric m) {
            this(m.getTimestamp(), m.getNumberValue().doubleValue());
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public double computeRate(Metric m) {
            long currentTimestamp = m.getTimestamp();
            double currentValue = m.getNumberValue().doubleValue();
            double millisPerSecond = 1000.0;
            double duration = (double)(currentTimestamp - this.timestamp) / 1000.0;
            double delta = currentValue - this.value;
            this.timestamp = currentTimestamp;
            this.value = currentValue;
            return duration <= 0.0 || delta <= 0.0 ? 0.0 : delta / duration;
        }
    }
}

