/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.tag;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.netflix.servo.tag.BasicTag;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;

public final class SortedTagList
implements TagList {
    public static final SortedTagList EMPTY = new Builder().build();
    private final SortedMap<String, Tag> tagSortedMap;
    private final int size;

    private SortedTagList(Builder builder) {
        this.tagSortedMap = ImmutableSortedMap.copyOf((Map)builder.data);
        this.size = this.tagSortedMap.size();
    }

    @Override
    public Tag getTag(String string) {
        return (Tag)this.tagSortedMap.get(string);
    }

    @Override
    public String getValue(String string) {
        Tag tag = (Tag)this.tagSortedMap.get(string);
        return tag == null ? null : tag.getValue();
    }

    @Override
    public boolean containsKey(String string) {
        return this.tagSortedMap.containsKey(string);
    }

    @Override
    public boolean isEmpty() {
        return this.tagSortedMap.isEmpty();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<Tag> iterator() {
        return this.tagSortedMap.values().iterator();
    }

    @Override
    public Map<String, String> asMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>(this.size());
        for (Tag tag : this.tagSortedMap.values()) {
            hashMap.put(tag.getKey(), tag.getValue());
        }
        return hashMap;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object object) {
        return object instanceof SortedTagList && this.tagSortedMap.equals(((SortedTagList)object).tagSortedMap);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tagSortedMap});
    }

    public String toString() {
        return Joiner.on((String)",").join(this.tagSortedMap.values());
    }

    public static final class Builder {
        private final Map<String, Tag> data = Maps.newHashMap();

        public Builder withTags(Collection<Tag> collection) {
            for (Tag tag : collection) {
                this.data.put(tag.getKey(), tag);
            }
            return this;
        }

        public Builder withTags(TagList tagList) {
            for (Tag tag : tagList) {
                this.data.put(tag.getKey(), tag);
            }
            return this;
        }

        public Builder withTag(Tag tag) {
            this.data.put(tag.getKey(), tag);
            return this;
        }

        public Builder withTag(String string, String string2) {
            return this.withTag(new BasicTag(string, string2));
        }

        public SortedTagList build() {
            return new SortedTagList(this);
        }
    }
}

