/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.tag;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.netflix.servo.tag.BasicTag;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class BasicTagList
implements TagList {
    public static final TagList EMPTY = new BasicTagList((Iterable<Tag>)ImmutableSet.of());
    private final Map<String, Tag> tagMap;

    public BasicTagList(Iterable<Tag> iterable) {
        HashMap hashMap = Maps.newHashMap();
        for (Tag tag : iterable) {
            hashMap.put(tag.getKey(), tag);
        }
        this.tagMap = ImmutableMap.copyOf((Map)hashMap);
    }

    @Override
    public Tag getTag(String string) {
        return this.tagMap.get(string);
    }

    @Override
    public String getValue(String string) {
        Tag tag = this.tagMap.get(string);
        return tag == null ? null : tag.getValue();
    }

    @Override
    public boolean containsKey(String string) {
        return this.tagMap.containsKey(string);
    }

    @Override
    public boolean isEmpty() {
        return this.tagMap.isEmpty();
    }

    @Override
    public int size() {
        return this.tagMap.size();
    }

    @Override
    public Iterator<Tag> iterator() {
        return this.tagMap.values().iterator();
    }

    @Override
    public Map<String, String> asMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Tag tag : this.tagMap.values()) {
            builder.put((Object)tag.getKey(), (Object)tag.getValue());
        }
        return builder.build();
    }

    public BasicTagList copy(TagList tagList) {
        return BasicTagList.concat((TagList)this, tagList);
    }

    public BasicTagList copy(String string, String string2) {
        return BasicTagList.concat((TagList)this, new BasicTag(string, string2));
    }

    public boolean equals(Object object) {
        return object instanceof BasicTagList && ((Object)this.tagMap).equals(((BasicTagList)object).tagMap);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tagMap});
    }

    public String toString() {
        return Joiner.on((String)",").join(this.tagMap.values());
    }

    public static BasicTagList concat(TagList tagList, TagList tagList2) {
        return new BasicTagList(Iterables.concat((Iterable)tagList, (Iterable)tagList2));
    }

    public static BasicTagList concat(TagList tagList, Tag ... tagArray) {
        return new BasicTagList(Iterables.concat((Iterable)tagList, Arrays.asList(tagArray)));
    }

    public static BasicTagList copyOf(Tag ... tagArray) {
        return new BasicTagList(Arrays.asList(tagArray));
    }

    public static BasicTagList copyOf(String ... stringArray) {
        return BasicTagList.copyOf(Arrays.asList(stringArray));
    }

    public static BasicTagList copyOf(Iterable<String> iterable) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String string : iterable) {
            builder.add((Object)BasicTag.parseTag(string));
        }
        return new BasicTagList((Iterable<Tag>)builder.build());
    }

    public static BasicTagList copyOf(Map<String, String> map) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.add((Object)new BasicTag(entry.getKey(), entry.getValue()));
        }
        return new BasicTagList((Iterable<Tag>)builder.build());
    }
}

