/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.tag;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.netflix.servo.tag.Tag;

public final class BasicTag
implements Tag {
    private final String key;
    private final String value;

    public BasicTag(String string, String string2) {
        this.key = this.checkNotEmpty(string, "key");
        this.value = this.checkNotEmpty(string2, "value");
    }

    private String checkNotEmpty(String string, String string2) {
        Preconditions.checkNotNull((Object)string, (String)"%s cannot be null", (Object[])new Object[]{string2});
        Preconditions.checkArgument((!"".equals(string) ? 1 : 0) != 0, (String)"%s cannot be empty", (Object[])new Object[]{string2});
        return string;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof BasicTag) {
            BasicTag basicTag = (BasicTag)object;
            return this.key.equals(basicTag.getKey()) && this.value.equals(basicTag.getValue());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.value});
    }

    public String toString() {
        return this.key + "=" + this.value;
    }

    public static BasicTag parseTag(String string) {
        int n = string.indexOf("=");
        if (n < 0) {
            throw new IllegalArgumentException("key and value must be separated by '='");
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1, string.length()).trim();
        return new BasicTag(string2, string3);
    }

    @Override
    public String tagString() {
        return this.toString();
    }
}

