/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.servo.publish.PollRunnable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class PollScheduler {
    private static final PollScheduler INSTANCE = new PollScheduler();
    private final AtomicReference<ScheduledExecutorService> executor = new AtomicReference();

    public static PollScheduler getInstance() {
        return INSTANCE;
    }

    private PollScheduler() {
    }

    public void addPoller(PollRunnable pollRunnable, long l, TimeUnit timeUnit) {
        ScheduledExecutorService scheduledExecutorService = this.executor.get();
        if (scheduledExecutorService == null) {
            throw new IllegalStateException("you must start the scheduler before tasks can be submitted");
        }
        scheduledExecutorService.scheduleAtFixedRate(pollRunnable, 0L, l, timeUnit);
    }

    public void start() {
        int n = Runtime.getRuntime().availableProcessors();
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ServoPollScheduler-%d").build();
        this.start(Executors.newScheduledThreadPool(n, threadFactory));
    }

    public void start(ScheduledExecutorService scheduledExecutorService) {
        if (!this.executor.compareAndSet(null, scheduledExecutorService)) {
            throw new IllegalStateException("cannot start scheduler again without stopping it");
        }
    }

    public void stop() {
        ScheduledExecutorService scheduledExecutorService = this.executor.get();
        if (scheduledExecutorService == null || !this.executor.compareAndSet(scheduledExecutorService, null)) {
            throw new IllegalStateException("scheduler must be started before you stop it");
        }
        scheduledExecutorService.shutdown();
    }

    public boolean isStarted() {
        return this.executor.get() != null;
    }
}

