/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.collect.Lists;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.Metric;
import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.ResettableMonitor;
import com.netflix.servo.publish.MetricFilter;
import com.netflix.servo.publish.MetricPoller;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MonitorRegistryMetricPoller
implements MetricPoller {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorRegistryMetricPoller.class);
    private final MonitorRegistry registry;

    public MonitorRegistryMetricPoller() {
        this(DefaultMonitorRegistry.getInstance());
    }

    public MonitorRegistryMetricPoller(MonitorRegistry monitorRegistry) {
        this.registry = monitorRegistry;
    }

    private Object getValue(Monitor<?> monitor, boolean bl) {
        if (bl && monitor instanceof ResettableMonitor) {
            return ((ResettableMonitor)monitor).getAndResetValue();
        }
        return monitor.getValue();
    }

    private void getMetrics(List<Metric> list, MetricFilter metricFilter, boolean bl, Monitor<?> monitor) throws Exception {
        LOGGER.debug("get metrics for: " + monitor);
        if (monitor instanceof CompositeMonitor) {
            for (Monitor<?> monitor2 : ((CompositeMonitor)monitor).getMonitors()) {
                this.getMetrics(list, metricFilter, bl, monitor2);
            }
        } else if (metricFilter.matches(monitor.getConfig())) {
            Object object = this.getValue(monitor, bl);
            long l = System.currentTimeMillis();
            list.add(new Metric(monitor.getConfig(), l, object));
        }
    }

    @Override
    public List<Metric> poll(MetricFilter metricFilter) {
        return this.poll(metricFilter, false);
    }

    @Override
    public List<Metric> poll(MetricFilter metricFilter, boolean bl) {
        ArrayList arrayList = Lists.newArrayList();
        for (Monitor<?> monitor : this.registry.getRegisteredMonitors()) {
            try {
                this.getMetrics(arrayList, metricFilter, bl, monitor);
            }
            catch (Exception exception) {
                LOGGER.warn("failed to get values for {}", (Object)exception, (Object)monitor.getConfig());
            }
        }
        return arrayList;
    }
}

